<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', 'JOLI Matelas'); ?></title>

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&family=Playfair+Display:wght@600;700;800&display=swap" rel="stylesheet">

    <!-- Tailwind CSS via CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Inter', 'system-ui', 'sans-serif'],
                        display: ['"Playfair Display"', 'Georgia', 'serif'],
                    },
                    colors: {
                        primary: {
                            DEFAULT: '#003D82',
                            foreground: '#ffffff',
                        },
                        secondary: {
                            DEFAULT: '#4A90E2',
                            foreground: '#ffffff',
                        },
                        accent: {
                            DEFAULT: '#C9A65C',
                            foreground: '#1a1a1a',
                        },
                        muted: {
                            DEFAULT: '#f1f5f9',
                            foreground: '#64748b',
                        },
                        destructive: {
                            DEFAULT: '#ef4444',
                            foreground: '#ffffff',
                        },
                        border: '#e2e8f0',
                        input: '#e2e8f0',
                        ring: '#003D82',
                        background: '#ffffff',
                        foreground: '#0f172a',
                        card: {
                            DEFAULT: '#ffffff',
                            foreground: '#0f172a',
                        },
                    },
                    maxWidth: {
                        '7xl': '80rem',
                    },
                },
            },
        }
    </script>

    <!-- Alpine.js -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>

    <!-- Lucide Icons -->
    <script src="https://unpkg.com/lucide@latest"></script>

    <style>
        [x-cloak] { display: none !important; }

        /* Display headings use serif font */
        .font-display { font-family: 'Playfair Display', Georgia, serif; }

        /* Buttons */
        .btn {
            @apply inline-flex items-center justify-center rounded-full text-sm font-medium transition-all duration-200;
            @apply focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-primary/40 focus-visible:ring-offset-2;
            @apply disabled:pointer-events-none disabled:opacity-50;
        }
        .btn-default {
            @apply bg-primary text-white hover:bg-primary/90 shadow-sm hover:shadow-md h-10 px-5 py-2;
        }
        .btn-accent {
            @apply bg-accent text-white hover:bg-accent/90 shadow-sm hover:shadow-md h-10 px-5 py-2;
        }
        .btn-outline {
            @apply border border-gray-200 text-gray-700 bg-white hover:border-primary/60 hover:text-primary hover:bg-gray-50 h-10 px-5 py-2;
        }
        .btn-ghost {
            @apply hover:bg-gray-100 h-10 px-5 py-2;
        }
        .btn-sm {
            @apply h-9 px-3 text-sm;
        }
        .btn-lg {
            @apply h-12 px-8 text-base;
        }
        .btn-icon {
            @apply h-10 w-10 p-0 flex items-center justify-center rounded-full;
        }
        .btn-square {
            @apply h-9 w-9 p-0 flex items-center justify-center rounded-lg;
        }

        /* Cards */
        .card {
            @apply rounded-2xl border border-gray-100 bg-white shadow-sm transition-all duration-200;
        }
        .card-header {
            @apply flex flex-col space-y-1.5 p-6;
        }
        .card-title {
            @apply text-xl font-semibold leading-none tracking-tight;
        }
        .card-content {
            @apply p-6 pt-0;
        }

        /* Form elements */
        .input {
            @apply flex h-11 w-full rounded-lg border border-gray-300 bg-white px-4 py-2 text-sm;
            @apply placeholder:text-gray-400 focus:outline-none focus:ring-2 focus:ring-primary/30 focus:border-primary;
            @apply disabled:cursor-not-allowed disabled:opacity-50;
            @apply transition-colors duration-200;
        }
        .input-bordered { /* compat alias */ }
        .input-error { @apply border-red-400 focus:ring-red-200 focus:border-red-400; }

        .select, .select-bordered {
            @apply flex h-11 w-full rounded-lg border border-gray-300 bg-white px-4 py-2 text-sm;
            @apply focus:outline-none focus:ring-2 focus:ring-primary/30 focus:border-primary;
            @apply transition-colors duration-200;
        }

        .textarea, .textarea-bordered {
            @apply w-full rounded-lg border border-gray-300 bg-white px-4 py-3 text-sm;
            @apply placeholder:text-gray-400 focus:outline-none focus:ring-2 focus:ring-primary/30 focus:border-primary;
            @apply transition-colors duration-200 resize-vertical;
        }

        /* Badges */
        .badge {
            @apply inline-flex items-center rounded-full px-2.5 py-0.5 text-xs font-semibold;
        }
        .badge-success { @apply bg-green-100 text-green-800; }
        .badge-destructive { @apply bg-red-100 text-red-800; }
        .badge-secondary { @apply bg-gray-100 text-gray-800; }

        /* Spinner */
        .spinner {
            @apply animate-spin rounded-full h-5 w-5 border-2 border-current border-t-transparent;
        }

        /* Page header banner - reusable across all pages */
        .page-header {
            @apply relative overflow-hidden bg-gradient-to-r from-primary via-primary to-primary/90 py-12 sm:py-14;
            background-image: radial-gradient(1200px circle at 10% 10%, rgba(255, 255, 255, 0.14), transparent 45%);
        }
        .page-header::after {
            content: "";
            position: absolute;
            inset: 0;
            background: linear-gradient(120deg, rgba(255, 255, 255, 0.08), transparent 55%);
            opacity: 0.8;
            pointer-events: none;
        }
        .page-header > div {
            position: relative;
            z-index: 1;
        }
        .page-header h1 {
            @apply text-3xl md:text-4xl font-bold text-white mb-2 font-display;
        }
        .page-header p {
            @apply text-white/80 text-lg;
        }

        :root {
            --font-heading: 'Playfair Display', Georgia, serif;
            --font-body: 'Inter', system-ui, sans-serif;
        }

        body, p, nav, label, input, textarea, select, button {
            font-family: var(--font-body);
        }

        h1, h2, h3, .font-display {
            font-family: var(--font-heading);
        }

        .hero-title {
            font-size: clamp(38px, 5vw, 58px);
            line-height: 1.10;
            font-weight: 700;
            letter-spacing: -0.02em;
            max-width: 900px;
        }

        .hero-subtitle {
            font-size: clamp(16px, 1.8vw, 22px);
            line-height: 1.55;
            font-weight: 400;
            opacity: 0.85;
            margin-top: 14px;
            max-width: 760px;
        }

        .page-hero-title {
            font-size: clamp(28px, 3.2vw, 42px);
            line-height: 1.18;
            font-weight: 700;
            letter-spacing: -0.015em;
        }

        .page-hero-subtitle {
            font-size: clamp(14px, 1.6vw, 18px);
            line-height: 1.60;
            font-weight: 400;
            opacity: 0.85;
            margin-top: 10px;
        }

        .section-title {
            font-size: clamp(24px, 2.6vw, 34px);
            line-height: 1.25;
            font-weight: 700;
        }

        .body-text {
            font-size: 16px;
            line-height: 1.70;
            font-weight: 400;
            opacity: 0.92;
        }

        .micro-text {
            font-size: 13px;
            line-height: 1.50;
        }

        h2 {
            font-size: clamp(24px, 2.6vw, 34px);
            line-height: 1.25;
            font-weight: 700;
        }

        p {
            font-size: 16px;
            line-height: 1.70;
            font-weight: 400;
            opacity: 0.92;
        }

        .btn {
            font-size: 14px;
            font-weight: 600;
            min-height: 44px;
        }

        .btn-lg {
            font-size: 15px;
            min-height: 48px;
        }

        /* Smooth scrolling */
        html { scroll-behavior: smooth; }
    </style>

    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body class="min-h-screen flex flex-col bg-gray-50 text-gray-900 font-sans antialiased">
    <!-- Toast Notifications -->
    <div x-data="{ toasts: [] }"
         x-on:toast.window="toasts.push($event.detail); setTimeout(() => toasts.shift(), 5000)"
         class="fixed top-4 right-4 z-[60] space-y-2">
        <template x-for="(toast, index) in toasts" :key="index">
            <div x-show="true"
                 x-transition:enter="transform ease-out duration-300"
                 x-transition:enter-start="translate-x-full opacity-0"
                 x-transition:enter-end="translate-x-0 opacity-100"
                 x-transition:leave="transform ease-in duration-200"
                 x-transition:leave-start="translate-x-0 opacity-100"
                 x-transition:leave-end="translate-x-full opacity-0"
                 :class="{
                     'bg-green-50 border-green-400 text-green-800': toast.type === 'success',
                     'bg-red-50 border-red-400 text-red-800': toast.type === 'error',
                     'bg-blue-50 border-blue-400 text-blue-800': toast.type === 'info'
                 }"
                 class="flex items-center gap-3 px-5 py-3 rounded-xl border shadow-lg max-w-sm backdrop-blur-sm">
                <span x-text="toast.message" class="text-sm font-medium"></span>
                <button @click="toasts.splice(index, 1)" class="ml-auto text-gray-400 hover:text-gray-600">
                    <i data-lucide="x" class="w-4 h-4"></i>
                </button>
            </div>
        </template>
    </div>

    <?php echo $__env->make('partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <main class="flex-1">
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <?php echo $__env->make('partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script>
        // Initialize Lucide icons
        lucide.createIcons();

        // Re-init after Alpine updates DOM
        document.addEventListener('alpine:initialized', () => {
            setTimeout(() => lucide.createIcons(), 100);
        });

        const SHOP_CURRENCY_CODE = <?php echo json_encode(config('shop.currency_code', 'XAF'), 512) ?>;
        const SHOP_CURRENCY_LOCALE = <?php echo json_encode(config('shop.currency_locale', 'fr-FR'), 512) ?>;

        // Toast helper function
        function showToast(message, type = 'success') {
            window.dispatchEvent(new CustomEvent('toast', {
                detail: { message, type }
            }));
        }

        // Format price helper
        function formatPrice(price) {
            return new Intl.NumberFormat(SHOP_CURRENCY_LOCALE, {
                style: 'currency',
                currency: SHOP_CURRENCY_CODE
            }).format(price);
        }
    </script>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>
<?php /**PATH C:\wamp64\www\Joli\backend-laravel\resources\views/layouts/app.blade.php ENDPATH**/ ?>