<?php $__env->startSection('title', 'Dashboard Admin'); ?>
<?php $__env->startSection('page-title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Stats Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        <!-- Products -->
        <div class="bg-white rounded-xl shadow-sm p-6">
            <div class="flex items-center justify-between mb-4">
                <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center">
                    <i data-lucide="package" class="h-6 w-6 text-blue-600"></i>
                </div>
                <span class="text-2xl font-bold"><?php echo e($productsStats['total']); ?></span>
            </div>
            <h3 class="text-gray-600 mb-1">Produits</h3>
            <p class="text-sm text-green-600"><?php echo e($productsStats['active']); ?> actifs</p>
        </div>

        <!-- Stores -->
        <div class="bg-white rounded-xl shadow-sm p-6">
            <div class="flex items-center justify-between mb-4">
                <div class="w-12 h-12 bg-purple-100 rounded-lg flex items-center justify-center">
                    <i data-lucide="store" class="h-6 w-6 text-purple-600"></i>
                </div>
                <span class="text-2xl font-bold"><?php echo e($storesStats['total']); ?></span>
            </div>
            <h3 class="text-gray-600 mb-1">Magasins</h3>
            <p class="text-sm text-green-600"><?php echo e($storesStats['active']); ?> actifs</p>
        </div>

        <!-- Orders -->
        <div class="bg-white rounded-xl shadow-sm p-6">
            <div class="flex items-center justify-between mb-4">
                <div class="w-12 h-12 bg-amber-100 rounded-lg flex items-center justify-center">
                    <i data-lucide="shopping-cart" class="h-6 w-6 text-amber-600"></i>
                </div>
                <span class="text-2xl font-bold"><?php echo e($ordersStats['total']); ?></span>
            </div>
            <h3 class="text-gray-600 mb-1">Commandes</h3>
            <p class="text-sm text-amber-600"><?php echo e($ordersStats['pending']); ?> en attente</p>
        </div>

        <!-- Revenue -->
        <div class="bg-white rounded-xl shadow-sm p-6">
            <div class="flex items-center justify-between mb-4">
                <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center">
                    <i data-lucide="banknote" class="h-6 w-6 text-green-600"></i>
                </div>
                <span class="text-2xl font-bold"><?php echo e(number_format($ordersStats['revenue'], 0, ',', ' ')); ?></span>
            </div>
            <h3 class="text-gray-600 mb-1">Chiffre d'affaires</h3>
            <p class="text-sm text-gray-500"><?php echo e(config('shop.currency_symbol')); ?> (Livrées)</p>
        </div>
    </div>

    <!-- Orders by Status -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        <div class="bg-white rounded-xl shadow-sm p-6">
            <div class="flex items-center gap-3 mb-2">
                <div class="w-3 h-3 bg-amber-500 rounded-full"></div>
                <h3 class="font-semibold">En attente</h3>
            </div>
            <p class="text-3xl font-bold text-amber-600"><?php echo e($ordersStats['pending']); ?></p>
        </div>

        <div class="bg-white rounded-xl shadow-sm p-6">
            <div class="flex items-center gap-3 mb-2">
                <div class="w-3 h-3 bg-blue-500 rounded-full"></div>
                <h3 class="font-semibold">En livraison</h3>
            </div>
            <p class="text-3xl font-bold text-blue-600"><?php echo e($ordersStats['shipping']); ?></p>
        </div>

        <div class="bg-white rounded-xl shadow-sm p-6">
            <div class="flex items-center gap-3 mb-2">
                <div class="w-3 h-3 bg-green-500 rounded-full"></div>
                <h3 class="font-semibold">Livrées</h3>
            </div>
            <p class="text-3xl font-bold text-green-600"><?php echo e($ordersStats['delivered']); ?></p>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Stock Alerts -->
        <div class="bg-white rounded-xl shadow-sm p-6">
            <div class="flex items-center justify-between mb-4">
                <h2 class="text-lg font-bold flex items-center gap-2">
                    <i data-lucide="alert-triangle" class="h-5 w-5 text-red-500"></i>
                    Alertes Stock
                </h2>
                <a href="<?php echo e(route('admin.stock.index', ['low_stock' => 'true'])); ?>" class="text-sm text-primary hover:underline">
                    Voir tout
                </a>
            </div>

            <?php if($lowStockAlerts->isEmpty()): ?>
                <p class="text-gray-500 text-center py-4">Aucune alerte de stock</p>
            <?php else: ?>
                <div class="space-y-3">
                    <?php $__currentLoopData = $lowStockAlerts->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $alert): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="flex items-center justify-between p-3 bg-red-50 rounded-lg">
                        <div class="flex-1">
                            <p class="font-medium text-sm"><?php echo e($alert->product->name); ?></p>
                            <p class="text-xs text-gray-600"><?php echo e($alert->variant->size); ?> - <?php echo e($alert->store->name); ?></p>
                        </div>
                        <span class="px-3 py-1 bg-red-100 text-red-700 rounded-full text-sm font-medium">
                            <?php echo e($alert->available_quantity); ?> restant
                        </span>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>
        </div>

        <!-- Recent Orders -->
        <div class="bg-white rounded-xl shadow-sm p-6">
            <div class="flex items-center justify-between mb-4">
                <h2 class="text-lg font-bold flex items-center gap-2">
                    <i data-lucide="shopping-bag" class="h-5 w-5 text-primary"></i>
                    Dernières Commandes
                </h2>
                <a href="<?php echo e(route('admin.orders.index')); ?>" class="text-sm text-primary hover:underline">
                    Voir tout
                </a>
            </div>

            <?php if($recentOrders->isEmpty()): ?>
                <p class="text-gray-500 text-center py-4">Aucune commande récente</p>
            <?php else: ?>
                <div class="space-y-3">
                    <?php $__currentLoopData = $recentOrders->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e(route('admin.orders.show', $order->id)); ?>"
                       class="flex items-center justify-between p-3 hover:bg-gray-50 rounded-lg transition-colors">
                        <div class="flex-1">
                            <p class="font-medium text-sm"><?php echo e($order->order_number); ?></p>
                            <p class="text-xs text-gray-600"><?php echo e($order->customer_first_name); ?> <?php echo e($order->customer_last_name); ?></p>
                        </div>
                        <div class="text-right">
                            <p class="font-medium text-sm"><?php echo e(number_format($order->total_amount, 0, ',', ' ')); ?> <?php echo e(config('shop.currency_symbol')); ?></p>
                            <span class="text-xs px-2 py-1 rounded-full
                                <?php if($order->status === 'EN_ATTENTE_TRAITEMENT'): ?> bg-amber-100 text-amber-700
                                <?php elseif($order->status === 'EN_ATTENTE_LIVRAISON'): ?> bg-blue-100 text-blue-700
                                <?php elseif($order->status === 'LIVREE'): ?> bg-green-100 text-green-700
                                <?php else: ?> bg-gray-100 text-gray-700
                                <?php endif; ?>">
                                <?php switch($order->status):
                                    case ('EN_ATTENTE_TRAITEMENT'): ?> En attente <?php break; ?>
                                    <?php case ('EN_ATTENTE_LIVRAISON'): ?> En livraison <?php break; ?>
                                    <?php case ('LIVREE'): ?> Livrée <?php break; ?>
                                    <?php case ('ANNULEE'): ?> Annulée <?php break; ?>
                                <?php endswitch; ?>
                            </span>
                        </div>
                    </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\Joli\backend-laravel\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>