<footer class="border-t border-gray-200 bg-white mt-auto">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-10 lg:py-12">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-10">
            <!-- Logo et description -->
            <div class="lg:col-span-1">
                <a href="<?php echo e(route('home')); ?>" class="inline-block mb-4">
                    <img
                        src="<?php echo e(asset('images/logo.jpg')); ?>"
                        alt="JOLI Matelas"
                        class="h-16 w-auto"
                    />
                </a>
                <p class="text-sm text-gray-500 leading-relaxed">
                    Votre spécialiste du matelas de qualité pour un sommeil réparateur.
                </p>
            </div>

            <!-- Navigation -->
            <div>
                <h3 class="font-semibold text-sm uppercase tracking-wider text-primary mb-4">Navigation</h3>
                <ul class="space-y-3 text-sm">
                    <li><a href="<?php echo e(route('products.index')); ?>" class="text-gray-500 hover:text-primary transition-colors">Nos Produits</a></li>
                    <li><a href="<?php echo e(route('promotions.index')); ?>" class="text-gray-500 hover:text-primary transition-colors">Promotions</a></li>
                    <li><a href="<?php echo e(route('services.index')); ?>" class="text-gray-500 hover:text-primary transition-colors">Services connexes</a></li>
                    <li><a href="<?php echo e(route('stores.index')); ?>" class="text-gray-500 hover:text-primary transition-colors">Nos Magasins</a></li>
                    <li><a href="<?php echo e(route('about')); ?>" class="text-gray-500 hover:text-primary transition-colors">À propos</a></li>
                    <li><a href="<?php echo e(route('contact')); ?>" class="text-gray-500 hover:text-primary transition-colors">Contact</a></li>
                </ul>
            </div>

            <!-- Informations -->
            <div>
                <h3 class="font-semibold text-sm uppercase tracking-wider text-primary mb-4">Informations</h3>
                <ul class="space-y-3 text-sm">
                    <li class="flex items-center gap-2 text-gray-500">
                        <i data-lucide="truck" class="h-4 w-4 text-accent flex-shrink-0"></i>
                        <span>Livraison gratuite</span>
                    </li>
                    <li class="flex items-center gap-2 text-gray-500">
                        <i data-lucide="banknote" class="h-4 w-4 text-accent flex-shrink-0"></i>
                        <span>Paiement à la livraison</span>
                    </li>
                    <li class="flex items-center gap-2 text-gray-500">
                        <i data-lucide="shield-check" class="h-4 w-4 text-accent flex-shrink-0"></i>
                        <span>Garantie qualité</span>
                    </li>
                </ul>
            </div>

            <!-- Contact -->
            <div>
                <h3 class="font-semibold text-sm uppercase tracking-wider text-primary mb-4">Contact</h3>
                <ul class="space-y-3 text-sm text-gray-500">
                    <li class="flex items-center gap-2">
                        <i data-lucide="phone" class="h-4 w-4 text-accent flex-shrink-0"></i>
                        <span>01 23 45 67 89</span>
                    </li>
                    <li class="flex items-center gap-2">
                        <i data-lucide="mail" class="h-4 w-4 text-accent flex-shrink-0"></i>
                        <span>contact@joli-matelas.fr</span>
                    </li>
                    <li class="flex items-center gap-2">
                        <i data-lucide="map-pin" class="h-4 w-4 text-accent flex-shrink-0"></i>
                        <span>Paris, France</span>
                    </li>
                </ul>
            </div>
        </div>

        <!-- Bottom bar: copyright left, admin right -->
        <div class="border-t border-gray-200 mt-8 pt-4 flex flex-col sm:flex-row items-center justify-between gap-3">
            <p class="text-sm text-gray-500">
                &copy; <?php echo e(date('Y')); ?> JOLI Matelas. Tous droits réservés.
            </p>
            <a href="<?php echo e(route('admin.login')); ?>"
               class="text-sm text-gray-500 hover:text-primary transition-colors">
                Administration
            </a>
        </div>
    </div>
</footer>
<?php /**PATH C:\wamp64\www\Joli\backend-laravel\resources\views/partials/footer.blade.php ENDPATH**/ ?>