<?php $__env->startSection('title', 'Contactez-nous - Jolis Matelas'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .contact-page .page-header {
        padding-top: 3.5rem;
        padding-bottom: 3.5rem;
        background: linear-gradient(120deg, #f8fafc 0%, #eff6ff 52%, #f8fafc 100%);
        border-bottom: 1px solid #e5e7eb;
    }
    .contact-page .page-header h1 {
        color: #003D82;
        text-align: center;
    }
    .contact-page .page-header p {
        color: #475569;
        text-align: center;
    }
    .contact-page .page-header nav {
        display: flex;
        justify-content: center;
        margin-bottom: 0.75rem;
    }
    .contact-page .page-header nav a {
        color: #64748b;
    }
    .contact-page .page-header nav span {
        color: #94a3b8;
    }
    .contact-page .page-header nav a:hover {
        color: #003D82;
    }
    .contact-page .contact-input {
        border: 1px solid #d1d5db;
        background-color: #ffffff;
    }
    .contact-page .contact-input::placeholder {
        color: #94a3b8;
    }
    .contact-page .contact-input:focus {
        border-color: #003D82;
        box-shadow: 0 0 0 3px rgba(0, 61, 130, 0.12);
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gray-50 contact-page">
    <?php echo $__env->make('partials.page-hero', [
        'title' => 'Contactez-nous',
        'subtitle' => 'Nous sommes à votre écoute',
        'breadcrumbs' => [
            ['label' => 'Accueil', 'href' => route('home')],
            ['label' => 'Contact']
        ]
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12 space-y-8">
        <?php if(session('success')): ?>
            <div class="rounded-xl border border-green-200 bg-green-50 p-4 text-sm text-green-700 flex items-center gap-2">
                <i data-lucide="check-circle" class="h-5 w-5 flex-shrink-0"></i>
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <?php if($errors->any()): ?>
            <div class="rounded-xl border border-red-200 bg-red-50 p-4 text-sm text-red-700">
                <ul class="list-disc pl-4 space-y-1">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <section class="grid grid-cols-1 lg:grid-cols-3 gap-10">
            <div class="lg:col-span-1 space-y-6">
                <div class="bg-white rounded-2xl shadow-sm p-6 border border-gray-100">
                    <h2 class="text-lg font-semibold text-primary mb-4 section-title">Coordonnées</h2>
                    <div class="space-y-3 text-sm text-gray-600">
                        <div class="flex items-center gap-3">
                            <i data-lucide="mail" class="h-4 w-4 text-accent flex-shrink-0"></i>
                            <a href="mailto:contact@jolismatelas.com" class="text-primary hover:underline">contact@jolismatelas.com</a>
                        </div>
                        <div class="flex items-center gap-3">
                            <i data-lucide="phone" class="h-4 w-4 text-accent flex-shrink-0"></i>
                            <span>Appelez le magasin le plus proche</span>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-2xl shadow-sm p-6 border border-gray-100">
                    <h2 class="text-lg font-semibold text-primary mb-4 section-title">Nos magasins</h2>
                    <?php if($stores->isEmpty()): ?>
                        <p class="text-sm text-gray-500 body-text">Aucun magasin actif pour le moment.</p>
                    <?php else: ?>
                        <div class="divide-y divide-gray-100 text-sm">
                            <?php $__currentLoopData = $stores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $store): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="py-4 first:pt-0 last:pb-0">
                                    <div class="font-medium text-gray-900"><?php echo e($store->name); ?></div>
                                    <div class="text-gray-500"><?php echo e($store->street); ?>, <?php echo e($store->postal_code); ?> <?php echo e($store->city); ?></div>
                                    <?php if($store->phone): ?>
                                        <div class="text-gray-500"><span class="font-medium text-gray-600">Téléphone :</span> <?php echo e($store->phone); ?></div>
                                    <?php endif; ?>
                                    <?php if($store->email): ?>
                                        <div class="text-gray-500"><span class="font-medium text-gray-600">Email :</span> <?php echo e($store->email); ?></div>
                                    <?php endif; ?>
                                    <?php if($store->opening_hours): ?>
                                        <div class="mt-2">
                                            <span class="font-medium text-gray-600">Horaires :</span>
                                            <div class="mt-1 space-y-0.5 text-gray-500">
                                                <?php $__currentLoopData = $store->opening_hours; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day => $hours): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div><?php echo e($day); ?> : <?php echo e($hours); ?></div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <div class="lg:col-span-2 bg-white rounded-2xl shadow-sm p-6 border border-gray-100">
                <h2 class="text-lg font-semibold text-primary mb-6 section-title">Envoyer un message</h2>
                <form method="POST" action="<?php echo e(route('contact.store')); ?>" class="space-y-5 contact-form">
                    <?php echo csrf_field(); ?>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-600 mb-2">Nom <span class="text-red-500">*</span></label>
                            <input type="text" name="name" value="<?php echo e(old('name')); ?>" required class="input contact-input">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-600 mb-2">Téléphone</label>
                            <input type="text" name="phone" value="<?php echo e(old('phone')); ?>" class="input contact-input">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-600 mb-2">Email <span class="text-red-500">*</span></label>
                            <input type="email" name="email" value="<?php echo e(old('email')); ?>" required class="input contact-input">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-600 mb-2">Sujet <span class="text-red-500">*</span></label>
                            <input type="text" name="subject" value="<?php echo e(old('subject')); ?>" required class="input contact-input">
                        </div>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-600 mb-2">Message <span class="text-red-500">*</span></label>
                        <textarea name="message" rows="6" required class="textarea contact-input" placeholder="Votre message..."><?php echo e(old('message')); ?></textarea>
                    </div>
                    <div class="flex justify-end">
                        <button type="submit" class="btn btn-default btn-lg gap-2">
                            <i data-lucide="send" class="h-4 w-4"></i>
                            Envoyer
                        </button>
                    </div>
                </form>
            </div>
        </section>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\Joli\backend-laravel\resources\views/contact.blade.php ENDPATH**/ ?>