<?php $__env->startSection('title', 'Nos Magasins - Jolis Matelas'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .stores-page .page-header {
        padding-top: 3.5rem;
        padding-bottom: 3.5rem;
        background: linear-gradient(120deg, #f8fafc 0%, #eff6ff 52%, #f8fafc 100%);
        border-bottom: 1px solid #e5e7eb;
    }
    .stores-page .page-header h1,
    .stores-page .page-header p {
        text-align: center;
    }
    .stores-page .page-header h1 {
        color: #003D82;
    }
    .stores-page .page-header p {
        color: #475569;
    }
    .stores-page .page-header nav {
        display: flex;
        justify-content: center;
        margin-bottom: 0.75rem;
    }
    .stores-page .page-header nav a {
        color: #64748b;
    }
    .stores-page .page-header nav span {
        color: #94a3b8;
    }
    .stores-page .page-header nav a:hover {
        color: #003D82;
    }
    .stores-page .stores-grid {
        max-width: 72rem;
        margin-left: auto;
        margin-right: auto;
    }
    .stores-page .store-card {
        border: 1px solid #e5e7eb;
        box-shadow: 0 12px 30px -24px rgba(15, 23, 42, 0.4);
    }
    .stores-page .store-card:hover {
        transform: translateY(-2px);
    }
    .stores-page .store-actions {
        display: grid;
        grid-template-columns: 1fr;
        gap: 0.75rem;
    }
    @media (min-width: 640px) {
        .stores-page .store-actions {
            grid-template-columns: repeat(2, minmax(0, 1fr));
        }
    }
    .stores-page .store-btn {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 0.5rem;
        width: 100%;
        padding: 0.75rem 1rem;
        border-radius: 0.75rem;
        font-weight: 600;
    }
    .stores-page .store-btn-primary {
        background: #003D82;
        color: #ffffff;
    }
    .stores-page .store-btn-primary:hover {
        background: #00356f;
    }
    .stores-page .store-btn-outline {
        border: 1px solid #C9A65C;
        color: #C9A65C;
    }
    .stores-page .store-btn-outline:hover {
        background: rgba(201, 166, 92, 0.12);
        color: #9f7f36;
    }
    .stores-page .store-muted {
        color: #94a3b8;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gray-50 stores-page">
    <?php echo $__env->make('partials.page-hero', [
        'title' => 'Nos Magasins',
        'subtitle' => 'Trouvez le magasin Jolis Matelas le plus proche de chez vous',
        'breadcrumbs' => [
            ['label' => 'Accueil', 'href' => route('home')],
            ['label' => 'Magasins']
        ]
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-10">
        <?php if($stores->isEmpty()): ?>
            <div class="text-center py-16 bg-white rounded-2xl border border-gray-100">
                <div class="w-16 h-16 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i data-lucide="store" class="h-8 w-8 text-gray-300"></i>
                </div>
                <h3 class="text-lg font-medium text-gray-900 mb-2">Aucun magasin disponible</h3>
                <p class="text-gray-500">Revenez bientôt !</p>
            </div>
        <?php else: ?>
            <div class="stores-grid grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <?php $__currentLoopData = $stores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $store): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="card store-card overflow-hidden transition-all bg-white">
                    <div class="p-6 flex flex-col h-full">
                        <div class="flex items-start justify-between mb-4">
                            <div>
                                <h3 class="text-xl font-bold text-primary"><?php echo e($store->name); ?></h3>
                                <p class="text-gray-500"><?php echo e($store->city ?? '—'); ?></p>
                            </div>
                            <div class="h-10 w-10 bg-primary/10 rounded-full flex items-center justify-center flex-shrink-0">
                                <i data-lucide="store" class="h-5 w-5 text-primary"></i>
                            </div>
                        </div>

                        <?php if($store->description): ?>
                        <p class="text-sm text-gray-500 mb-4"><?php echo e($store->description); ?></p>
                        <?php endif; ?>

                        <div class="space-y-3">
                            <!-- Address -->
                            <?php if($store->street || $store->postal_code || $store->city): ?>
                            <div class="flex items-start gap-3">
                                <i data-lucide="map-pin" class="h-4 w-4 text-accent flex-shrink-0 mt-0.5"></i>
                                <div class="text-sm text-gray-600">
                                    <?php if($store->street): ?>
                                        <p><?php echo e($store->street); ?></p>
                                    <?php endif; ?>
                                    <p>
                                        <?php echo e($store->postal_code ?? ''); ?>

                                        <?php echo e($store->city ?? ''); ?>

                                    </p>
                                </div>
                            </div>
                            <?php endif; ?>

                            <!-- Phone -->
                            <?php if($store->phone): ?>
                            <div class="flex items-center gap-3">
                                <i data-lucide="phone" class="h-4 w-4 text-accent flex-shrink-0"></i>
                                <a href="tel:<?php echo e($store->phone); ?>" class="text-sm text-gray-600 hover:text-primary transition-colors">
                                    <?php echo e($store->phone); ?>

                                </a>
                            </div>
                            <?php endif; ?>

                            <!-- Email -->
                            <?php if($store->email): ?>
                            <div class="flex items-center gap-3">
                                <i data-lucide="mail" class="h-4 w-4 text-accent flex-shrink-0"></i>
                                <a href="mailto:<?php echo e($store->email); ?>" class="text-sm text-gray-600 hover:text-primary transition-colors">
                                    <?php echo e($store->email); ?>

                                </a>
                            </div>
                            <?php endif; ?>

                            <!-- Opening Hours -->
                            <?php if($store->opening_hours): ?>
                            <div class="flex items-start gap-3">
                                <i data-lucide="clock" class="h-4 w-4 text-accent flex-shrink-0 mt-0.5"></i>
                                <div class="text-sm text-gray-600">
                                    <?php $__currentLoopData = $store->opening_hours; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day => $hours): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <p><span class="font-medium"><?php echo e($day); ?> :</span> <?php echo e($hours); ?></p>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>

                        <!-- Actions -->
                        <div class="mt-6 pt-4 border-t border-gray-100 store-actions">
                            <?php if($store->latitude && $store->longitude): ?>
                            <a href="https://www.google.com/maps?q=<?php echo e($store->latitude); ?>,<?php echo e($store->longitude); ?>"
                               target="_blank" rel="noopener noreferrer"
                               class="store-btn store-btn-outline text-sm">
                                <i data-lucide="navigation" class="h-4 w-4"></i>
                                Itinéraire
                            </a>
                            <?php endif; ?>
                            <?php if($store->phone): ?>
                            <a href="tel:<?php echo e($store->phone); ?>"
                               class="store-btn store-btn-primary text-sm">
                                <i data-lucide="phone" class="h-4 w-4"></i>
                                Appeler le magasin
                            </a>
                            <?php else: ?>
                            <div class="store-btn store-btn-outline text-sm store-muted">
                                Téléphone indisponible
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\Joli\backend-laravel\resources\views/stores/index.blade.php ENDPATH**/ ?>