﻿

<?php $__env->startSection('title', 'Parametres'); ?>
<?php $__env->startSection('page-title', 'Parametres'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-3xl">
    <form action="<?php echo e(route('admin.settings.update')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <!-- Informations generales -->
        <div class="bg-white rounded-lg shadow-sm p-6 mb-6">
            <h2 class="text-lg font-semibold mb-4 flex items-center gap-2">
                <i data-lucide="building" class="h-5 w-5 text-primary"></i>
                Informations generales
            </h2>

            <div class="space-y-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Nom du site</label>
                    <input type="text" name="site_name" value="<?php echo e(old('site_name', $settings['site_name']['value'])); ?>"
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-primary focus:border-transparent">
                    <p class="text-xs text-gray-500 mt-1"><?php echo e($settings['site_name']['description']); ?></p>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Email de contact</label>
                    <input type="email" name="contact_email" value="<?php echo e(old('contact_email', $settings['contact_email']['value'])); ?>"
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-primary focus:border-transparent">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Telephone de contact</label>
                    <input type="text" name="contact_phone" value="<?php echo e(old('contact_phone', $settings['contact_phone']['value'])); ?>"
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-primary focus:border-transparent">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Adresse de l'entreprise</label>
                    <textarea name="company_address" rows="2"
                              class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-primary focus:border-transparent"><?php echo e(old('company_address', $settings['company_address']['value'])); ?></textarea>
                </div>
            </div>
        </div>

        <!-- Boutique -->
        <div class="bg-white rounded-lg shadow-sm p-6 mb-6">
            <h2 class="text-lg font-semibold mb-4 flex items-center gap-2">
                <i data-lucide="shopping-bag" class="h-5 w-5 text-primary"></i>
                Boutique
            </h2>

            <div class="space-y-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Symbole de devise</label>
                    <input type="text" name="currency_symbol" value="<?php echo e(old('currency_symbol', $settings['currency_symbol']['value'])); ?>"
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-primary focus:border-transparent">
                    <p class="text-xs text-gray-500 mt-1">
                        Affiche apres les prix (ex: XAF, DH, EUR).
                        Note : la devise affichee cote public utilise <code>config/shop.php</code> (SHOP_CURRENCY_SYMBOL dans .env).
                        Ce parametre est stocke en base pour reference.
                    </p>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Seuil d'alerte stock bas</label>
                    <input type="number" name="low_stock_threshold" min="0"
                           value="<?php echo e(old('low_stock_threshold', $settings['low_stock_threshold']['value'])); ?>"
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-primary focus:border-transparent">
                    <p class="text-xs text-gray-500 mt-1">Quantite en-dessous de laquelle une alerte sera declenchee.</p>
                </div>
            </div>
        </div>

        <!-- Notifications -->
        <div class="bg-white rounded-lg shadow-sm p-6 mb-6">
            <h2 class="text-lg font-semibold mb-4 flex items-center gap-2">
                <i data-lucide="bell" class="h-5 w-5 text-primary"></i>
                Notifications
            </h2>

            <div class="space-y-4">
                <div class="flex items-center gap-2">
                    <input type="checkbox" name="order_notification_enabled" value="1" id="order_notification_enabled"
                           <?php echo e($settings['order_notification_enabled']['value'] ? 'checked' : ''); ?>

                           class="rounded border-gray-300 text-primary focus:ring-primary">
                    <label for="order_notification_enabled" class="text-sm text-gray-700">
                        Activer les notifications de commande par email
                    </label>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Emails de notification admin</label>
                    <textarea name="admin_notification_emails" rows="2"
                              class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm font-mono focus:ring-2 focus:ring-primary focus:border-transparent"><?php echo e(old('admin_notification_emails', json_encode($settings['admin_notification_emails']['value'], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE))); ?></textarea>
                    <p class="text-xs text-gray-500 mt-1">Format JSON : <code>["admin@example.com", "manager@example.com"]</code></p>
                </div>
            </div>
        </div>

        <!-- Mail sortant -->
        <div class="bg-white rounded-lg shadow-sm p-6 mb-6">
            <h2 class="text-lg font-semibold mb-4 flex items-center gap-2">
                <i data-lucide="mail" class="h-5 w-5 text-primary"></i>
                Mail sortant (SMTP)
            </h2>

            <div class="space-y-4">
                <div class="flex items-center gap-2">
                    <input type="checkbox" name="mail_enabled" value="1" id="mail_enabled"
                           <?php echo e($settings['mail_enabled']['value'] ? 'checked' : ''); ?>

                           class="rounded border-gray-300 text-primary focus:ring-primary">
                    <label for="mail_enabled" class="text-sm text-gray-700">
                        Activer les emails sortants
                    </label>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Mailer</label>
                        <select name="mail_mailer" class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm">
                            <option value="smtp" <?php echo e(old('mail_mailer', $settings['mail_mailer']['value']) === 'smtp' ? 'selected' : ''); ?>>smtp</option>
                        </select>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Encryption</label>
                        <select name="mail_encryption" class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm">
                            <?php
                                $encryptionValue = old('mail_encryption', $settings['mail_encryption']['value']);
                                if ($encryptionValue === '') {
                                    $encryptionValue = 'none';
                                }
                            ?>
                            <option value="tls" <?php echo e($encryptionValue === 'tls' ? 'selected' : ''); ?>>tls</option>
                            <option value="ssl" <?php echo e($encryptionValue === 'ssl' ? 'selected' : ''); ?>>ssl</option>
                            <option value="none" <?php echo e($encryptionValue === 'none' ? 'selected' : ''); ?>>none</option>
                        </select>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Host *</label>
                        <input type="text" name="mail_host" value="<?php echo e(old('mail_host', $settings['mail_host']['value'])); ?>"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Port *</label>
                        <input type="number" name="mail_port" value="<?php echo e(old('mail_port', $settings['mail_port']['value'])); ?>"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Username</label>
                        <input type="text" name="mail_username" value="<?php echo e(old('mail_username', $settings['mail_username']['value'])); ?>"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Password</label>
                        <input type="password" name="mail_password" value=""
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm">
                        <p class="text-xs text-gray-500 mt-1">Laisser vide pour conserver le mot de passe actuel.</p>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">From address *</label>
                        <input type="email" name="mail_from_address" value="<?php echo e(old('mail_from_address', $settings['mail_from_address']['value'])); ?>"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">From name</label>
                        <input type="text" name="mail_from_name" value="<?php echo e(old('mail_from_name', $settings['mail_from_name']['value'])); ?>"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Reply-to address</label>
                        <input type="email" name="mail_reply_to_address" value="<?php echo e(old('mail_reply_to_address', $settings['mail_reply_to_address']['value'])); ?>"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Reply-to name</label>
                        <input type="text" name="mail_reply_to_name" value="<?php echo e(old('mail_reply_to_name', $settings['mail_reply_to_name']['value'])); ?>"
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm">
                    </div>
                </div>

                <p class="text-xs text-gray-500">Les champs host/port/from sont obligatoires lorsque les emails sont actifs.</p>
            </div>
        </div>

        <!-- Submit -->
        <div class="flex items-center gap-3">
            <button type="submit" class="px-6 py-2 bg-primary text-white rounded-lg text-sm hover:bg-primary/90">
                Enregistrer les parametres
            </button>
        </div>
    </form>

    <!-- Test email -->
    <form action="<?php echo e(route('admin.settings.test-email')); ?>" method="POST" class="mt-6">
        <?php echo csrf_field(); ?>
        <div class="bg-white rounded-lg shadow-sm p-6">
            <h2 class="text-lg font-semibold mb-4 flex items-center gap-2">
                <i data-lucide="send" class="h-5 w-5 text-primary"></i>
                Envoyer un email de test
            </h2>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-3">
                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-gray-700 mb-1">Destinataire test</label>
                    <input type="email" name="test_email_to" value="<?php echo e(old('test_email_to', $settings['contact_email']['value'])); ?>"
                           class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm">
                </div>
                <div class="flex items-end">
                    <button type="submit" class="px-4 py-2 bg-gray-800 text-white rounded-lg text-sm">Envoyer</button>
                </div>
            </div>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\Joli\backend-laravel\resources\views/admin/settings/index.blade.php ENDPATH**/ ?>