<?php

use App\Http\Controllers\HomeController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\CartController;
use App\Http\Controllers\CheckoutController;
use App\Http\Controllers\StoreController;
use App\Http\Controllers\PromotionController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
*/

// Homepage
Route::get('/', [HomeController::class, 'index'])->name('home');

// Products
Route::get('/produits', [ProductController::class, 'index'])->name('products.index');
Route::get('/produits/{slug}', [ProductController::class, 'show'])->name('products.show');

// Static pages
Route::get('/a-propos', \App\Http\Controllers\AboutController::class)->name('about');

// Contact
Route::get('/contact', [\App\Http\Controllers\ContactController::class, 'index'])->name('contact');
Route::post('/contact', [\App\Http\Controllers\ContactController::class, 'store'])->name('contact.store');

// Services
Route::get('/services', [\App\Http\Controllers\ServiceController::class, 'index'])->name('services.index');

// Cart
Route::get('/panier', [CartController::class, 'index'])->name('cart.index');
Route::post('/panier/ajouter', [CartController::class, 'add'])->name('cart.add');
Route::post('/panier/modifier', [CartController::class, 'update'])->name('cart.update');
Route::post('/panier/supprimer', [CartController::class, 'remove'])->name('cart.remove');
Route::post('/panier/vider', [CartController::class, 'clear'])->name('cart.clear');
Route::get('/panier/json', [CartController::class, 'get'])->name('cart.get');

// Checkout
Route::get('/commande', [CheckoutController::class, 'index'])->name('checkout.index');
Route::post('/commande', [CheckoutController::class, 'store'])->name('checkout.store');
Route::get('/commande/confirmation/{uuid}', [CheckoutController::class, 'confirmation'])->name('checkout.confirmation');

// Stores
Route::get('/magasins', [StoreController::class, 'index'])->name('stores.index');
Route::get('/magasins/{id}', [StoreController::class, 'show'])->name('stores.show');

// Promotions
Route::get('/promotions', [PromotionController::class, 'index'])->name('promotions.index');

/*
|--------------------------------------------------------------------------
| Web Routes - Admin
|--------------------------------------------------------------------------
*/

// Admin Auth
Route::prefix('admin')->name('admin.')->group(function () {
    Route::get('login', [\App\Http\Controllers\Admin\AuthController::class, 'showLoginForm'])->name('login');
    Route::post('login', [\App\Http\Controllers\Admin\AuthController::class, 'login']);
    Route::post('logout', [\App\Http\Controllers\Admin\AuthController::class, 'logout'])->name('logout');

    // Protected Admin Routes
    Route::middleware(['auth', 'admin'])->group(function () {
        Route::get('/', [\App\Http\Controllers\Admin\DashboardController::class, 'index'])->name('dashboard');

        // Orders
        Route::prefix('orders')->name('orders.')->group(function () {
            Route::get('/', [\App\Http\Controllers\Admin\OrderController::class, 'index'])->name('index');
            Route::get('/{id}', [\App\Http\Controllers\Admin\OrderController::class, 'show'])->name('show');
            Route::post('/{id}/status', [\App\Http\Controllers\Admin\OrderController::class, 'updateStatus'])->name('updateStatus');
        });

        // Categories
        Route::prefix('categories')->name('categories.')->group(function () {
            Route::get('/', [\App\Http\Controllers\Admin\CategoryController::class, 'index'])->name('index');
            Route::get('/create', [\App\Http\Controllers\Admin\CategoryController::class, 'create'])->name('create');
            Route::post('/', [\App\Http\Controllers\Admin\CategoryController::class, 'store'])->name('store');
            Route::get('/{id}/edit', [\App\Http\Controllers\Admin\CategoryController::class, 'edit'])->name('edit');
            Route::put('/{id}', [\App\Http\Controllers\Admin\CategoryController::class, 'update'])->name('update');
            Route::delete('/{id}', [\App\Http\Controllers\Admin\CategoryController::class, 'destroy'])->name('destroy');
            Route::post('/{id}/toggle', [\App\Http\Controllers\Admin\CategoryController::class, 'toggleActive'])->name('toggle');
        });

        // Product Attributes
        Route::prefix('product-attributes')->name('product-attributes.')->group(function () {
            Route::get('/', [\App\Http\Controllers\Admin\ProductAttributeController::class, 'index'])->name('index');
            Route::get('/create', [\App\Http\Controllers\Admin\ProductAttributeController::class, 'create'])->name('create');
            Route::post('/', [\App\Http\Controllers\Admin\ProductAttributeController::class, 'store'])->name('store');
            Route::get('/{id}/edit', [\App\Http\Controllers\Admin\ProductAttributeController::class, 'edit'])->name('edit');
            Route::put('/{id}', [\App\Http\Controllers\Admin\ProductAttributeController::class, 'update'])->name('update');
            Route::delete('/{id}', [\App\Http\Controllers\Admin\ProductAttributeController::class, 'destroy'])->name('destroy');
        });

        // Products
        Route::prefix('products')->name('products.')->group(function () {
            Route::get('/', [\App\Http\Controllers\Admin\ProductController::class, 'index'])->name('index');
            Route::get('/create', [\App\Http\Controllers\Admin\ProductController::class, 'create'])->name('create');
            Route::post('/', [\App\Http\Controllers\Admin\ProductController::class, 'store'])->name('store');
            Route::get('/{id}/edit', [\App\Http\Controllers\Admin\ProductController::class, 'edit'])->name('edit');
            Route::put('/{id}', [\App\Http\Controllers\Admin\ProductController::class, 'update'])->name('update');
            Route::delete('/{id}', [\App\Http\Controllers\Admin\ProductController::class, 'destroy'])->name('destroy');
            Route::post('/{id}/toggle', [\App\Http\Controllers\Admin\ProductController::class, 'toggleActive'])->name('toggle');
            Route::post('/{id}/variants', [\App\Http\Controllers\Admin\ProductController::class, 'storeVariant'])->name('variants.store');
            Route::delete('/{id}/variants/{variantId}', [\App\Http\Controllers\Admin\ProductController::class, 'destroyVariant'])->name('variants.destroy');
        });

        // Services
        Route::prefix('services')->name('services.')->group(function () {
            Route::get('/', [\App\Http\Controllers\Admin\ServiceController::class, 'index'])->name('index');
            Route::get('/create', [\App\Http\Controllers\Admin\ServiceController::class, 'create'])->name('create');
            Route::post('/', [\App\Http\Controllers\Admin\ServiceController::class, 'store'])->name('store');
            Route::get('/{id}/edit', [\App\Http\Controllers\Admin\ServiceController::class, 'edit'])->name('edit');
            Route::put('/{id}', [\App\Http\Controllers\Admin\ServiceController::class, 'update'])->name('update');
            Route::delete('/{id}', [\App\Http\Controllers\Admin\ServiceController::class, 'destroy'])->name('destroy');
            Route::post('/{id}/toggle', [\App\Http\Controllers\Admin\ServiceController::class, 'toggleActive'])->name('toggle');
        });

        // Stock
        Route::prefix('stock')->name('stock.')->group(function () {
            Route::get('/', [\App\Http\Controllers\Admin\StockController::class, 'index'])->name('index');
            Route::get('/mouvements', [\App\Http\Controllers\Admin\StockController::class, 'movements'])->name('movements.index');
            Route::post('/mouvements', [\App\Http\Controllers\Admin\StockController::class, 'storeMovement'])->name('movements.store');
            Route::prefix('inventaires')->name('inventories.')->group(function () {
                Route::get('/', [\App\Http\Controllers\Admin\StockInventoryController::class, 'index'])->name('index');
                Route::get('/create', [\App\Http\Controllers\Admin\StockInventoryController::class, 'create'])->name('create');
                Route::post('/', [\App\Http\Controllers\Admin\StockInventoryController::class, 'store'])->name('store');
                Route::get('/{id}', [\App\Http\Controllers\Admin\StockInventoryController::class, 'show'])->name('show');
                Route::post('/{id}/save', [\App\Http\Controllers\Admin\StockInventoryController::class, 'saveLines'])->name('save');
                Route::post('/{id}/validate', [\App\Http\Controllers\Admin\StockInventoryController::class, 'validateInventory'])->name('validate');
                Route::get('/{id}/export', [\App\Http\Controllers\Admin\StockInventoryController::class, 'exportCsv'])->name('export');
            });
            Route::get('/create', [\App\Http\Controllers\Admin\StockController::class, 'create'])->name('create');
            Route::post('/', [\App\Http\Controllers\Admin\StockController::class, 'store'])->name('store');
            Route::post('/adjust', [\App\Http\Controllers\Admin\StockController::class, 'adjust'])->name('adjust');
        });

        // Stores
        Route::prefix('stores')->name('stores.')->group(function () {
            Route::get('/', [\App\Http\Controllers\Admin\StoreController::class, 'index'])->name('index');
            Route::get('/create', [\App\Http\Controllers\Admin\StoreController::class, 'create'])->name('create');
            Route::post('/', [\App\Http\Controllers\Admin\StoreController::class, 'store'])->name('store');
            Route::get('/{id}/edit', [\App\Http\Controllers\Admin\StoreController::class, 'edit'])->name('edit');
            Route::put('/{id}', [\App\Http\Controllers\Admin\StoreController::class, 'update'])->name('update');
            Route::delete('/{id}', [\App\Http\Controllers\Admin\StoreController::class, 'destroy'])->name('destroy');
            Route::post('/{id}/toggle', [\App\Http\Controllers\Admin\StoreController::class, 'toggleActive'])->name('toggle');
        });

        // Users
        Route::prefix('users')->name('users.')->group(function () {
            Route::get('/', [\App\Http\Controllers\Admin\UserController::class, 'index'])->name('index');
            Route::get('/create', [\App\Http\Controllers\Admin\UserController::class, 'create'])->name('create');
            Route::post('/', [\App\Http\Controllers\Admin\UserController::class, 'store'])->name('store');
            Route::get('/{id}/edit', [\App\Http\Controllers\Admin\UserController::class, 'edit'])->name('edit');
            Route::put('/{id}', [\App\Http\Controllers\Admin\UserController::class, 'update'])->name('update');
            Route::delete('/{id}', [\App\Http\Controllers\Admin\UserController::class, 'destroy'])->name('destroy');
            Route::post('/{id}/toggle', [\App\Http\Controllers\Admin\UserController::class, 'toggleActive'])->name('toggle');
        });

        // Promotions
        Route::prefix('promotions')->name('promotions.')->group(function () {
            Route::get('/', [\App\Http\Controllers\Admin\PromotionController::class, 'index'])->name('index');
            Route::get('/create', [\App\Http\Controllers\Admin\PromotionController::class, 'create'])->name('create');
            Route::post('/', [\App\Http\Controllers\Admin\PromotionController::class, 'store'])->name('store');
            Route::get('/{id}/edit', [\App\Http\Controllers\Admin\PromotionController::class, 'edit'])->name('edit');
            Route::put('/{id}', [\App\Http\Controllers\Admin\PromotionController::class, 'update'])->name('update');
            Route::delete('/{id}', [\App\Http\Controllers\Admin\PromotionController::class, 'destroy'])->name('destroy');
            Route::post('/{id}/toggle', [\App\Http\Controllers\Admin\PromotionController::class, 'toggleActive'])->name('toggle');
        });

        // Settings
        Route::prefix('settings')->name('settings.')->group(function () {
            Route::get('/', [\App\Http\Controllers\Admin\SettingController::class, 'index'])->name('index');
            Route::put('/', [\App\Http\Controllers\Admin\SettingController::class, 'update'])->name('update');
            Route::post('/test-email', [\App\Http\Controllers\Admin\SettingController::class, 'sendTestEmail'])->name('test-email');
        });
    });
});
