@extends('layouts.app')

@section('title', $store->name . ' - JOLI Matelas')

@section('content')
<div class="min-h-screen bg-gray-50 py-10">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <a href="{{ route('stores.index') }}" class="inline-flex items-center gap-1 text-sm text-primary hover:underline mb-6">
            <i data-lucide="arrow-left" class="h-4 w-4"></i>
            Retour aux magasins
        </a>

        <div class="bg-white rounded-xl shadow-sm p-8">
            <div class="flex items-start justify-between mb-6">
                <div>
                    <h1 class="text-3xl font-bold text-primary font-display">{{ $store->name }}</h1>
                    <p class="text-gray-500 mt-1">{{ $store->city }}</p>
                </div>
                <div class="h-12 w-12 bg-primary/10 rounded-full flex items-center justify-center flex-shrink-0">
                    <i data-lucide="store" class="h-6 w-6 text-primary"></i>
                </div>
            </div>

            @if($store->description)
            <p class="text-gray-600 leading-relaxed mb-6">{{ $store->description }}</p>
            @endif

            <div class="space-y-3 text-sm">
                <div class="flex items-start gap-3">
                    <i data-lucide="map-pin" class="h-4 w-4 text-accent flex-shrink-0 mt-0.5"></i>
                    <span class="text-gray-600">{{ $store->street }}, {{ $store->postal_code }} {{ $store->city }}</span>
                </div>
                @if($store->phone)
                <div class="flex items-center gap-3">
                    <i data-lucide="phone" class="h-4 w-4 text-accent flex-shrink-0"></i>
                    <a href="tel:{{ $store->phone }}" class="text-gray-600 hover:text-primary transition-colors">{{ $store->phone }}</a>
                </div>
                @endif
                @if($store->email)
                <div class="flex items-center gap-3">
                    <i data-lucide="mail" class="h-4 w-4 text-accent flex-shrink-0"></i>
                    <a href="mailto:{{ $store->email }}" class="text-gray-600 hover:text-primary transition-colors">{{ $store->email }}</a>
                </div>
                @endif
                @if($store->opening_hours)
                <div class="flex items-start gap-3">
                    <i data-lucide="clock" class="h-4 w-4 text-accent flex-shrink-0 mt-0.5"></i>
                    <div class="text-gray-600">
                        @foreach($store->opening_hours as $day => $hours)
                        <p><span class="font-medium">{{ $day }} :</span> {{ $hours }}</p>
                        @endforeach
                    </div>
                </div>
                @endif
            </div>

            @if($store->latitude && $store->longitude)
            <div class="mt-6 pt-6 border-t border-gray-100 flex gap-3">
                <a href="https://www.google.com/maps?q={{ $store->latitude }},{{ $store->longitude }}"
                   target="_blank" rel="noopener noreferrer"
                   class="btn btn-outline gap-2">
                    <i data-lucide="navigation" class="h-4 w-4"></i>
                    Voir sur la carte
                </a>
                @if($store->phone)
                <a href="tel:{{ $store->phone }}"
                   class="btn bg-primary text-white hover:bg-primary/90 gap-2">
                    <i data-lucide="phone" class="h-4 w-4"></i>
                    Appeler
                </a>
                @endif
            </div>
            @endif
        </div>
    </div>
</div>
@endsection
