@extends('layouts.app')

@section('title', $product->name . ' - JOLI Matelas')

@section('content')
<div class="min-h-screen bg-gray-50">
    @include('partials.page-hero', [
        'title' => $product->name,
        'subtitle' => $product->short_desc ? \Illuminate\Support\Str::limit($product->short_desc, 120) : null,
        'breadcrumbs' => [
            ['label' => 'Accueil', 'href' => route('home')],
            ['label' => 'Produits', 'href' => route('products.index')],
            ['label' => $product->name]
        ]
    ])

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
        <div class="bg-white rounded-2xl shadow-sm overflow-hidden border border-gray-100">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-10 p-6 lg:p-10"
                 x-data="{
                    selectedVariant: {{ $product->variants->first()->id ?? 'null' }},
                    quantity: 1,
                    currentImage: 0,
                    loading: false,
                    getVariant() {
                        return this.variants.find(v => v.id === this.selectedVariant);
                    },
                    variants: {{ $product->variants->toJson() }}
                 }">
                <!-- Images -->
                <div class="space-y-4">
                    @if($product->images && count($product->images) > 0)
                        <div class="aspect-square rounded-xl overflow-hidden bg-gray-100">
                            <img :src="'{{ asset('storage') }}/' + ({{ json_encode($product->images) }}[currentImage] || '{{ $product->thumbnail }}')"
                                 alt="{{ $product->name }}"
                                 class="w-full h-full object-cover">
                        </div>
                        @if(count($product->images) > 1)
                        <div class="flex gap-2 overflow-x-auto pb-2">
                            @foreach($product->images as $index => $image)
                            <button @click="currentImage = {{ $index }}"
                                    :class="currentImage === {{ $index }} ? 'ring-2 ring-primary' : 'ring-1 ring-gray-200'"
                                    class="flex-shrink-0 w-20 h-20 rounded-lg overflow-hidden transition-all">
                                <img src="{{ asset('storage/' . $image) }}" alt="" class="w-full h-full object-cover">
                            </button>
                            @endforeach
                        </div>
                        @endif
                    @else
                        <div class="aspect-square rounded-xl bg-gray-100 overflow-hidden">
                            <img src="{{ asset('images/placeholder.jpg') }}" alt="{{ $product->name }}" class="h-full w-full object-cover">
                        </div>
                    @endif
                </div>

                <!-- Product Info -->
                <div class="space-y-6">
                    <div>
                        @if($product->category)
                        <span class="badge bg-primary/10 text-primary mb-3 inline-block">{{ $product->category->name }}</span>
                        @endif
                        <h1 class="text-3xl font-bold text-primary mb-3 font-display">{{ $product->name }}</h1>
                        @if($product->short_desc)
                            <p class="text-gray-500 leading-relaxed">{{ $product->short_desc }}</p>
                        @endif
                    </div>

                    <!-- Price -->
                    <div class="text-3xl font-bold text-accent">
                        <span x-text="getVariant()?.price?.toLocaleString('fr-FR') || '{{ number_format($product->base_price, 0, ',', ' ') }}'"></span>
                        {{ config('shop.currency_symbol', 'XAF') }}
                    </div>

                    <!-- Variants (Sizes) -->
                    @if($product->variants->count() > 1)
                    <div>
                        <label class="block text-sm font-medium text-gray-600 mb-3">Taille</label>
                        <div class="flex flex-wrap gap-2">
                            @foreach($product->variants as $variant)
                            <button @click="selectedVariant = {{ $variant->id }}"
                                    :class="selectedVariant === {{ $variant->id }}
                                        ? 'bg-primary text-white border-primary'
                                        : 'bg-white text-gray-700 border-gray-300 hover:border-primary'"
                                    class="px-4 py-2 border-2 rounded-lg font-medium transition-all">
                                {{ $variant->size }}
                            </button>
                            @endforeach
                        </div>
                    </div>
                    @elseif($product->variants->count() === 1)
                    <div>
                        <label class="block text-sm font-medium text-gray-600 mb-2">Taille</label>
                        <span class="inline-block px-4 py-2 bg-primary text-white border-2 border-primary rounded-lg font-medium">
                            {{ $product->variants->first()->size }}
                        </span>
                    </div>
                    @endif

                    <!-- Quantity -->
                    <div>
                        <label class="block text-sm font-medium text-gray-600 mb-3">Quantité</label>
                        <div class="flex items-center gap-3">
                            <button @click="quantity = Math.max(1, quantity - 1)"
                                    class="btn btn-square btn-outline rounded-lg">
                                <i data-lucide="minus" class="h-4 w-4"></i>
                            </button>
                            <input type="number" x-model.number="quantity" min="1"
                                   class="input w-20 text-center">
                            <button @click="quantity++"
                                    class="btn btn-square btn-outline rounded-lg">
                                <i data-lucide="plus" class="h-4 w-4"></i>
                            </button>
                        </div>
                    </div>

                    <!-- Add to Cart -->
                    <button @click="
                        loading = true;
                        fetch('{{ route('cart.add') }}', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': document.querySelector('meta[name=csrf-token]')?.content || '{{ csrf_token() }}',
                                'Accept': 'application/json'
                            },
                            body: JSON.stringify({
                                variant_id: selectedVariant,
                                quantity: quantity
                            })
                        })
                        .then(async r => {
                            const data = await r.json().catch(() => null);
                            loading = false;
                            if (r.ok && data && data.success) {
                                $dispatch('toast', { type: 'success', message: data.message });
                                $dispatch('cart-updated', { count: data.cart.total_items });
                            } else {
                                const msg = data?.message || data?.errors && Object.values(data.errors).flat()[0] || 'Erreur ' + r.status;
                                $dispatch('toast', { type: 'error', message: msg });
                            }
                        })
                        .catch(() => {
                            loading = false;
                            $dispatch('toast', { type: 'error', message: 'Erreur réseau, veuillez réessayer' });
                        });
                    "
                    :disabled="loading"
                    class="btn btn-lg w-full bg-accent hover:bg-accent/90 text-white gap-2 shadow-md hover:shadow-lg">
                        <template x-if="loading">
                            <span class="spinner"></span>
                        </template>
                        <template x-if="!loading">
                            <i data-lucide="shopping-cart" class="h-5 w-5"></i>
                        </template>
                        <span x-text="loading ? 'Ajout...' : 'Ajouter au panier'"></span>
                    </button>

                    <!-- Features -->
                    <div class="grid grid-cols-2 gap-4 pt-6 border-t border-gray-100">
                        @if($product->material)
                        <div class="flex items-center gap-2">
                            <i data-lucide="layers" class="h-5 w-5 text-primary"></i>
                            <span class="text-sm text-gray-600">{{ $product->material }}</span>
                        </div>
                        @endif
                        @if($product->firmness)
                        <div class="flex items-center gap-2">
                            <i data-lucide="gauge" class="h-5 w-5 text-primary"></i>
                            <span class="text-sm text-gray-600">Fermeté : {{ config('shop.product_firmness_labels')[$product->firmness] ?? ucfirst($product->firmness) }}</span>
                        </div>
                        @endif
                        @if($product->height)
                        <div class="flex items-center gap-2">
                            <i data-lucide="ruler" class="h-5 w-5 text-primary"></i>
                            <span class="text-sm text-gray-600">Épaisseur : {{ $product->height }} cm</span>
                        </div>
                        @endif
                        @if($product->warranty)
                        <div class="flex items-center gap-2">
                            <i data-lucide="shield-check" class="h-5 w-5 text-primary"></i>
                            <span class="text-sm text-gray-600">Garantie : {{ $product->warranty }} ans</span>
                        </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Description -->
            @if($product->description)
            <div class="border-t border-gray-100 p-6 lg:p-10">
                <h2 class="text-xl font-bold text-primary mb-4 font-display">Description</h2>
                <div class="prose max-w-none text-gray-600 leading-relaxed">
                    {!! nl2br(e($product->description)) !!}
                </div>
            </div>
            @endif
        </div>

        <!-- Related Products -->
        @if($relatedProducts->isNotEmpty())
        <section class="mt-16">
            <h2 class="text-2xl font-bold text-primary mb-8 font-display">Produits similaires</h2>
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
                @foreach($relatedProducts as $relatedProduct)
                    @include('partials.product-card', ['product' => $relatedProduct])
                @endforeach
            </div>
        </section>
        @endif
    </div>
</div>
@endsection
