<header class="sticky top-0 z-50 w-full border-b border-gray-100 bg-white/95 backdrop-blur supports-[backdrop-filter]:bg-white/80 shadow-sm">
    <div class="max-w-7xl mx-auto flex h-20 items-center justify-between px-4 sm:px-6 lg:px-8">
        <!-- Logo -->
        <a href="{{ route('home') }}" class="flex items-center flex-shrink-0">
            <img
                src="{{ asset('images/logo.jpg') }}"
                alt="JOLI Matelas"
                class="h-14 w-auto"
            />
        </a>

        <!-- Navigation principale (desktop) -->
        <nav class="hidden lg:flex items-center gap-8">
            <a href="{{ route('products.index') }}"
               class="text-sm font-medium text-gray-700 hover:text-primary transition-colors {{ request()->routeIs('products.*') ? 'text-primary' : '' }}">
                Nos Produits
            </a>
            <a href="{{ route('promotions.index') }}"
               class="text-sm font-medium text-gray-700 hover:text-primary transition-colors {{ request()->routeIs('promotions.*') ? 'text-primary' : '' }}">
                Promotions
            </a>
            <a href="{{ route('services.index') }}"
               class="text-sm font-medium text-gray-700 hover:text-primary transition-colors {{ request()->routeIs('services.*') ? 'text-primary' : '' }}">
                Services connexes
            </a>
            <a href="{{ route('stores.index') }}"
               class="text-sm font-medium text-gray-700 hover:text-primary transition-colors {{ request()->routeIs('stores.*') ? 'text-primary' : '' }}">
                Nos Magasins
            </a>
            <a href="{{ route('about') }}"
               class="text-sm font-medium text-gray-700 hover:text-primary transition-colors {{ request()->routeIs('about') ? 'text-primary' : '' }}">
                À propos
            </a>
            <a href="{{ route('contact') }}"
               class="text-sm font-medium text-gray-700 hover:text-primary transition-colors {{ request()->routeIs('contact') ? 'text-primary' : '' }}">
                Contact
            </a>
        </nav>

        <!-- Actions -->
        <div class="flex items-center gap-3">
            <!-- Panier -->
            <a href="{{ route('cart.index') }}" class="relative"
               x-data="{ count: {{ app(\App\Services\CartService::class)->getItemCount() }} }"
               @cart-updated.window="count = $event.detail.count">
                <span class="btn btn-outline btn-icon rounded-full relative">
                    <i data-lucide="shopping-cart" class="h-5 w-5"></i>
                    <span x-show="count > 0"
                          x-text="count"
                          x-cloak
                          class="absolute -right-1.5 -top-1.5 h-5 w-5 rounded-full bg-accent text-white text-xs flex items-center justify-center font-bold">
                    </span>
                </span>
            </a>

            <!-- Menu mobile toggle -->
            <div x-data="{ open: false }" class="lg:hidden">
                <button @click="open = !open" class="btn btn-outline btn-icon rounded-full">
                    <i x-show="!open" data-lucide="menu" class="h-5 w-5"></i>
                    <i x-show="open" x-cloak data-lucide="x" class="h-5 w-5"></i>
                </button>

                <!-- Mobile menu dropdown -->
                <div x-show="open"
                     x-cloak
                     x-transition:enter="transition ease-out duration-200"
                     x-transition:enter-start="opacity-0 -translate-y-2"
                     x-transition:enter-end="opacity-100 translate-y-0"
                     x-transition:leave="transition ease-in duration-150"
                     x-transition:leave-start="opacity-100 translate-y-0"
                     x-transition:leave-end="opacity-0 -translate-y-2"
                     @click.away="open = false"
                     class="absolute top-full left-0 right-0 bg-white border-b border-gray-100 shadow-lg">
                    <nav class="max-w-7xl mx-auto px-4 py-2 flex flex-col divide-y divide-gray-100">
                        <a href="{{ route('products.index') }}" class="py-3 text-sm font-medium text-gray-700 hover:text-primary {{ request()->routeIs('products.*') ? 'text-primary' : '' }}">Nos Produits</a>
                        <a href="{{ route('promotions.index') }}" class="py-3 text-sm font-medium text-gray-700 hover:text-primary {{ request()->routeIs('promotions.*') ? 'text-primary' : '' }}">Promotions</a>
                        <a href="{{ route('services.index') }}" class="py-3 text-sm font-medium text-gray-700 hover:text-primary {{ request()->routeIs('services.*') ? 'text-primary' : '' }}">Services connexes</a>
                        <a href="{{ route('stores.index') }}" class="py-3 text-sm font-medium text-gray-700 hover:text-primary {{ request()->routeIs('stores.*') ? 'text-primary' : '' }}">Nos Magasins</a>
                        <a href="{{ route('about') }}" class="py-3 text-sm font-medium text-gray-700 hover:text-primary {{ request()->routeIs('about') ? 'text-primary' : '' }}">À propos</a>
                        <a href="{{ route('contact') }}" class="py-3 text-sm font-medium text-gray-700 hover:text-primary {{ request()->routeIs('contact') ? 'text-primary' : '' }}">Contact</a>
                        <a href="{{ route('cart.index') }}" class="py-3 text-sm font-medium text-gray-700 hover:text-primary {{ request()->routeIs('cart.*') ? 'text-primary' : '' }}">Mon Panier</a>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</header>
