@extends('layouts.app')

@section('title', 'Jolis Matelas – Expert du matelas orthopédique au Cameroun')

@push('styles')
<style>
    .home-page .btn {
        border-radius: 0.75rem;
        padding-left: 1.75rem;
        padding-right: 1.75rem;
    }
    .home-page .btn.btn-lg {
        height: auto;
        padding: 1rem 2.25rem;
    }
    .home-page .hero-cta {
        min-height: 3.5rem;
    }
    .home-page .cta-button {
        min-height: 3.5rem;
    }
    .home-page .home-product-grid .btn {
        height: auto;
        padding: 0.75rem 1.5rem;
        width: auto;
        align-self: center;
    }
    .home-page .product-card-cta {
        text-align: center;
    }
    .home-page .home-promo-card {
        height: 100%;
        border-color: #e5e7eb;
        box-shadow: 0 10px 25px -20px rgba(15, 23, 42, 0.35);
    }
    .home-page .home-product-grid .card {
        border-color: #e5e7eb;
        box-shadow: 0 10px 25px -20px rgba(15, 23, 42, 0.35);
    }
</style>
@endpush

@section('content')
<div class="flex flex-col home-page">
    <!-- Hero Section (Video Slider) -->
    <section
        class="relative overflow-hidden bg-gray-900"
        x-data="{
            slides: [
                {
                    title: 'Fini les douleurs de dos, de cou, de colonne vertébrale et de reins',
                    subtitle: 'Découvrez des matelas orthopédiques adaptés à votre santé et à votre sommeil',
                    video: '{{ asset('videos/hero/hero-1.mp4') }}',
                    cta1: { label: 'Voir nos matelas', href: '{{ route('products.index') }}' },
                    cta2: { label: 'Trouver un magasin', href: '{{ route('stores.index') }}' }
                },
                {
                    title: 'Le confort pensé pour vous',
                    subtitle: 'Des matelas, lits et accessoires conçus pour améliorer votre bien-être et votre qualité de sommeil.',
                    video: '{{ asset('videos/hero/hero-2.mp4') }}',
                    cta1: { label: 'Voir nos matelas', href: '{{ route('products.index') }}' },
                    cta2: { label: 'En savoir plus', href: '{{ route('about') }}' }
                },
                {
                    title: 'Dormez mieux, vivez mieux',
                    subtitle: 'Pour chaque matelas acheté, un oreiller est offert.',
                    video: '{{ asset('videos/hero/hero-3.mp4') }}',
                    cta1: { label: 'Commander maintenant', href: '{{ route('products.index') }}' },
                    cta2: { label: 'Nous contacter', href: '{{ route('contact') }}' }
                }
            ],
            active: 0,
            timer: null,
            start() {
                this.stop();
                this.timer = setInterval(() => this.next(), 7000);
            },
            stop() {
                if (this.timer) {
                    clearInterval(this.timer);
                    this.timer = null;
                }
            },
            next() {
                this.active = (this.active + 1) % this.slides.length;
            },
            prev() {
                this.active = (this.active - 1 + this.slides.length) % this.slides.length;
            },
            goTo(index) {
                this.active = index;
                this.start();
            }
        }"
        x-init="start()"
        @mouseenter="stop()"
        @mouseleave="start()"
    >
        <template x-for="(slide, index) in slides" :key="index">
            <div
                x-show="active === index"
                x-transition:enter="transition ease-out duration-700"
                x-transition:enter-start="opacity-0 scale-105"
                x-transition:enter-end="opacity-100 scale-100"
                x-transition:leave="transition ease-in duration-500"
                x-transition:leave-start="opacity-100"
                x-transition:leave-end="opacity-0"
                class="absolute inset-0 pointer-events-none"
            >
                <video
                    class="h-full w-full object-cover"
                    :src="slide.video"
                    autoplay
                    muted
                    loop
                    playsinline
                    preload="metadata"
                ></video>
                <div class="absolute inset-0 bg-black/45"></div>
            </div>
        </template>

        <div class="relative z-10">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="min-h-[70vh] md:min-h-[78vh] flex items-center justify-center text-center">
                    <div class="max-w-2xl mx-auto">
                        <div class="mb-6">
                            <span class="inline-flex items-center gap-2 text-xs uppercase tracking-[0.2em] text-white/70 justify-center">
                                Joli Matelas
                            </span>
                        </div>
                        <h1 class="text-3xl sm:text-4xl md:text-5xl lg:text-6xl font-bold tracking-tight leading-tight mb-6 text-white font-display hero-title">
                            <span x-text="slides[active].title"></span>
                        </h1>
                        <p class="text-base sm:text-lg md:text-xl text-white/85 mb-10 leading-relaxed max-w-2xl mx-auto hero-subtitle">
                            <span x-text="slides[active].subtitle"></span>
                        </p>
                        <div class="flex flex-col sm:flex-row items-center justify-center gap-4 sm:gap-6">
                            <a :href="slides[active].cta1.href"
                               class="btn btn-lg hero-cta bg-accent hover:bg-accent/90 text-white border-0 shadow-lg hover:shadow-xl w-full sm:w-auto">
                                <span x-text="slides[active].cta1.label"></span>
                            </a>
                            <a :href="slides[active].cta2.href"
                               class="btn btn-lg hero-cta border-2 border-white/40 text-white hover:bg-white/10 backdrop-blur-sm w-full sm:w-auto">
                                <span x-text="slides[active].cta2.label"></span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="absolute inset-y-0 left-0 right-0 flex items-center justify-between px-4 sm:px-6 lg:px-8 z-20 pointer-events-none">
            <button
                @click="prev(); start()"
                class="pointer-events-auto h-11 w-11 rounded-full bg-white/10 hover:bg-white/20 border border-white/20 text-white flex items-center justify-center transition"
                aria-label="Précédent"
            >
                <i data-lucide="chevron-left" class="h-5 w-5"></i>
            </button>
            <button
                @click="next(); start()"
                class="pointer-events-auto h-11 w-11 rounded-full bg-white/10 hover:bg-white/20 border border-white/20 text-white flex items-center justify-center transition"
                aria-label="Suivant"
            >
                <i data-lucide="chevron-right" class="h-5 w-5"></i>
            </button>
        </div>

        <div class="absolute bottom-6 left-0 right-0 flex items-center justify-center gap-3 z-20">
            <template x-for="(slide, index) in slides" :key="index">
                <button
                    @click="goTo(index)"
                    class="h-2.5 w-2.5 rounded-full transition"
                    :class="active === index ? 'bg-accent' : 'bg-white/40'"
                    aria-label="Aller au slide"
                ></button>
            </template>
        </div>
    </section>
    <!-- Pourquoi nous choisir -->
    <section class="py-20 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-10">
                <h2 class="text-3xl font-bold tracking-tight mb-2 text-primary font-display section-title">
                    Pourquoi nous choisir
                </h2>
            </div>
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
                <div class="flex flex-col items-center text-center p-7 rounded-2xl bg-gray-50 hover:bg-gray-100/80 transition-all shadow-sm border border-gray-100 hover:shadow-md">
                    <div class="h-14 w-14 rounded-full bg-primary/10 flex items-center justify-center mb-4">
                        <i data-lucide="shield-check" class="h-7 w-7 text-primary"></i>
                    </div>
                    <h3 class="font-semibold text-base sm:text-lg mb-2 text-gray-900">Qualité Premium</h3>
                    <p class="text-gray-500 text-sm">
                        Des matelas sélectionnés avec soin pour un confort durable
                    </p>
                </div>

                <div class="flex flex-col items-center text-center p-7 rounded-2xl bg-gray-50 hover:bg-gray-100/80 transition-all shadow-sm border border-gray-100 hover:shadow-md">
                    <div class="h-14 w-14 rounded-full bg-accent/10 flex items-center justify-center mb-4">
                        <i data-lucide="badge-check" class="h-7 w-7 text-accent"></i>
                    </div>
                    <h3 class="font-semibold text-base sm:text-lg mb-2 text-gray-900">Confiance</h3>
                    <p class="text-gray-500 text-sm">
                        Produits neufs, scellés et plastifiés
                    </p>
                </div>

                <div class="flex flex-col items-center text-center p-7 rounded-2xl bg-gray-50 hover:bg-gray-100/80 transition-all shadow-sm border border-gray-100 hover:shadow-md">
                    <div class="h-14 w-14 rounded-full bg-primary/10 flex items-center justify-center mb-4">
                        <i data-lucide="heart-handshake" class="h-7 w-7 text-primary"></i>
                    </div>
                    <h3 class="font-semibold text-base sm:text-lg mb-2 text-gray-900">Service attentif</h3>
                    <p class="text-gray-500 text-sm">
                        Conseils personnalisés avant et après achat
                    </p>
                </div>

                <div class="flex flex-col items-center text-center p-7 rounded-2xl bg-gray-50 hover:bg-gray-100/80 transition-all shadow-sm border border-gray-100 hover:shadow-md">
                    <div class="h-14 w-14 rounded-full bg-accent/10 flex items-center justify-center mb-4">
                        <i data-lucide="map-pin" class="h-7 w-7 text-accent"></i>
                    </div>
                    <h3 class="font-semibold text-base sm:text-lg mb-2 text-gray-900">Engagement local</h3>
                    <p class="text-gray-500 text-sm">
                        Une présence proche de vous au Cameroun
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- Promotions actives -->
    @if($promotions->count() > 0)
    <section class="py-20 bg-gray-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-10">
                <h2 class="text-3xl font-bold tracking-tight mb-3 text-primary font-display section-title">
                    Promotions en cours
                </h2>
                <p class="text-gray-500 body-text">
                    Profitez de nos offres exceptionnelles
                </p>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 home-promo-grid">
                @foreach($promotions as $promo)
                <div class="card hover:shadow-md hover:-translate-y-0.5 transition-all home-promo-card flex flex-col bg-white border border-gray-200">
                    <div class="aspect-[4/3] w-full overflow-hidden rounded-2xl bg-gray-100">
                        @if($promo->image_path)
                            <img src="{{ asset('storage/' . $promo->image_path) }}" alt="{{ $promo->title }}" class="h-full w-full object-cover">
                        @else
                            <img src="{{ asset('images/placeholder.jpg') }}" alt="Promotion JOLI Matelas" class="h-full w-full object-cover opacity-80">
                        @endif
                    </div>
                    <div class="p-6 flex flex-col flex-1">
                    <div class="flex items-start justify-between mb-4">
                        <div>
                            <span class="badge bg-accent/10 text-accent mb-2">PROMO</span>
                            <h3 class="font-semibold text-lg text-gray-900">{{ $promo->title }}</h3>
                        </div>
                        <div class="h-10 w-10 rounded-full bg-accent/10 flex items-center justify-center flex-shrink-0">
                            <i data-lucide="tag" class="h-5 w-5 text-accent"></i>
                        </div>
                    </div>
                    <p class="text-gray-500 text-sm mb-4">
                        {{ $promo->description }}
                    </p>
                    @if($promo->end_date)
                    <div class="flex items-center gap-2 text-xs text-gray-400 mt-auto">
                        <i data-lucide="calendar" class="h-3.5 w-3.5"></i>
                        <span>Jusqu'au {{ $promo->end_date->format('d/m/Y') }}</span>
                    </div>
                    @else
                    <div class="text-xs text-gray-400 mt-auto">
                        Offre en cours
                    </div>
                    @endif
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </section>
    @endif

    <!-- Produits en vedette -->
    <section class="py-20 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-10 max-w-2xl mx-auto">
                <h2 class="text-3xl font-bold tracking-tight mb-2 text-primary font-display section-title">
                    Nos Produits
                </h2>
                <p class="text-gray-500 body-text">
                    Découvrez notre sélection de produits de qualité
                </p>
                @if(!empty($featuredFallback))
                    <p class="text-xs text-gray-400 mt-2 micro-text">
                        Aucun produit favori pour le moment. Voici nos derniers produits.
                    </p>
                @endif
                <div class="mt-6 flex justify-center">
                    <a href="{{ route('products.index') }}"
                       class="btn btn-outline gap-2 border-primary text-primary hover:bg-primary hover:text-white">
                        Voir tout
                        <i data-lucide="arrow-right" class="h-4 w-4"></i>
                    </a>
                </div>
            </div>

            @if($products->isEmpty())
                <div class="text-center py-12">
                    <p class="text-gray-500">Aucun produit disponible</p>
                </div>
            @else
                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6 home-product-grid">
                    @foreach($products as $product)
                        @include('partials.product-card', ['product' => $product])
                    @endforeach
                </div>
            @endif
        </div>
    </section>

    <!-- Notre promesse -->
    <section class="relative bg-primary text-white py-24 overflow-hidden">
        <div class="absolute inset-0 bg-[url('/images/pattern.png')] opacity-5"></div>
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center relative z-10">
            <h2 class="text-3xl font-bold mb-4 font-display section-title">
                Le confort au service de votre santé
            </h2>
            <p class="text-lg text-white/85 leading-relaxed body-text">
                Jolis Matelas s’engage à vous proposer des matelas orthopédiques et semi-orthopédiques adaptés à vos besoins, pour un sommeil réparateur et sans douleur.
            </p>
        </div>
    </section>
</div>
@endsection
