@extends('layouts.app')

@section('title', 'Commande - JOLI Matelas')

@section('content')
<div class="min-h-screen bg-gray-50">
    @include('partials.page-hero', [
        'title' => 'Finaliser ma commande',
        'breadcrumbs' => [
            ['label' => 'Accueil', 'href' => route('home')],
            ['label' => 'Commande']
        ]
    ])

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">

        @if(session('error'))
        <div class="bg-red-50 border border-red-200 text-red-700 rounded-lg p-4 mb-6 flex items-center gap-3">
            <i data-lucide="alert-circle" class="h-5 w-5"></i>
            <span>{{ session('error') }}</span>
        </div>
        @endif

        <form action="{{ route('checkout.store') }}" method="POST"
              x-data="{ submitting: false }"
              @submit="submitting = true">
            @csrf

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
                <!-- Customer Info -->
                <div class="lg:col-span-2 space-y-6">
                    <!-- Personal Info -->
                    <div class="bg-white rounded-xl shadow-sm p-6">
                        <h2 class="text-lg font-bold text-primary mb-4 flex items-center gap-2">
                            <i data-lucide="user" class="h-5 w-5"></i>
                            Informations personnelles
                        </h2>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-600 mb-1">
                                    Prénom <span class="text-red-500">*</span>
                                </label>
                                <input type="text" name="customer_first_name" required
                                       value="{{ old('customer_first_name') }}"
                                       class="input input-bordered w-full @error('customer_first_name') input-error @enderror"
                                       placeholder="Votre prénom">
                                @error('customer_first_name')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                @enderror
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-600 mb-1">
                                    Nom <span class="text-red-500">*</span>
                                </label>
                                <input type="text" name="customer_last_name" required
                                       value="{{ old('customer_last_name') }}"
                                       class="input input-bordered w-full @error('customer_last_name') input-error @enderror"
                                       placeholder="Votre nom">
                                @error('customer_last_name')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                @enderror
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-600 mb-1">
                                    Téléphone <span class="text-red-500">*</span>
                                </label>
                                <input type="tel" name="customer_phone" required
                                       value="{{ old('customer_phone') }}"
                                       class="input input-bordered w-full @error('customer_phone') input-error @enderror"
                                       placeholder="06 XX XX XX XX">
                                @error('customer_phone')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                @enderror
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-600 mb-1">
                                    Email
                                </label>
                                <input type="email" name="customer_email"
                                       value="{{ old('customer_email') }}"
                                       class="input input-bordered w-full @error('customer_email') input-error @enderror"
                                       placeholder="votre@email.com">
                                @error('customer_email')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Delivery Address -->
                    <div class="bg-white rounded-xl shadow-sm p-6">
                        <h2 class="text-lg font-bold text-primary mb-4 flex items-center gap-2">
                            <i data-lucide="map-pin" class="h-5 w-5"></i>
                            Adresse de livraison
                        </h2>

                        <div class="space-y-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-600 mb-1">
                                    Adresse <span class="text-red-500">*</span>
                                </label>
                                <input type="text" name="delivery_street" required
                                       value="{{ old('delivery_street') }}"
                                       class="input input-bordered w-full @error('delivery_street') input-error @enderror"
                                       placeholder="Numéro et nom de rue">
                                @error('delivery_street')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-600 mb-1">
                                        Ville <span class="text-red-500">*</span>
                                    </label>
                                    <input type="text" name="delivery_city" required
                                           value="{{ old('delivery_city') }}"
                                           class="input input-bordered w-full @error('delivery_city') input-error @enderror"
                                           placeholder="Votre ville">
                                    @error('delivery_city')
                                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <label class="block text-sm font-medium text-gray-600 mb-1">
                                        Code postal
                                    </label>
                                    <input type="text" name="delivery_postal_code"
                                           value="{{ old('delivery_postal_code') }}"
                                           class="input input-bordered w-full @error('delivery_postal_code') input-error @enderror"
                                           placeholder="Code postal (optionnel)">
                                    @error('delivery_postal_code')
                                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Notes -->
                    <div class="bg-white rounded-xl shadow-sm p-6">
                        <h2 class="text-lg font-bold text-primary mb-4 flex items-center gap-2">
                            <i data-lucide="message-square" class="h-5 w-5"></i>
                            Notes (optionnel)
                        </h2>

                        <textarea name="notes" rows="3"
                                  class="textarea textarea-bordered w-full"
                                  placeholder="Instructions spéciales pour la livraison...">{{ old('notes') }}</textarea>
                    </div>
                </div>

                <!-- Order Summary -->
                <div class="lg:col-span-1">
                    <div class="bg-white rounded-xl shadow-sm p-6 sticky top-24">
                        <h2 class="text-lg font-bold text-primary mb-4">Votre commande</h2>

                        <!-- Items -->
                        <div class="space-y-3 mb-4">
                            @foreach($cart['items'] as $item)
                            <div class="flex gap-3 pb-3 border-b">
                                <div class="w-12 h-12 flex-shrink-0 rounded bg-gray-100 overflow-hidden">
                                    @if($item['product']->thumbnail)
                                        <img src="{{ asset('storage/' . $item['product']->thumbnail) }}"
                                             alt="" class="w-full h-full object-cover">
                                    @endif
                                </div>
                                <div class="flex-1 min-w-0">
                                    <p class="text-sm font-medium truncate">{{ $item['product']->name }}</p>
                                    <p class="text-xs text-muted-foreground">{{ $item['variant']->size }} × {{ $item['quantity'] }}</p>
                                </div>
                                <span class="text-sm font-medium">{{ number_format($item['subtotal'], 0, ',', ' ') }} {{ config('shop.currency_symbol') }}</span>
                            </div>
                            @endforeach
                        </div>

                        <!-- Totals -->
                        <div class="space-y-2 text-sm">
                            <div class="flex justify-between">
                                <span class="text-muted-foreground">Sous-total</span>
                                <span>{{ number_format($cart['total_price'], 0, ',', ' ') }} {{ config('shop.currency_symbol') }}</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-muted-foreground">Livraison</span>
                                <span class="text-green-600">Gratuite</span>
                            </div>
                            <div class="border-t pt-2 flex justify-between text-lg font-bold">
                                <span>Total</span>
                                <span class="text-accent">{{ number_format($cart['total_price'], 0, ',', ' ') }} {{ config('shop.currency_symbol') }}</span>
                            </div>
                        </div>

                        <!-- Payment Info -->
                        <div class="mt-4 p-3 bg-amber-50 rounded-lg">
                            <div class="flex items-center gap-2 text-amber-700 text-sm font-medium">
                                <i data-lucide="banknote" class="h-4 w-4"></i>
                                Paiement à la livraison
                            </div>
                            <p class="text-xs text-amber-600 mt-1">
                                Vous payez en espèces à la réception de votre commande
                            </p>
                        </div>

                        <!-- Submit Button -->
                        <button type="submit"
                                :disabled="submitting"
                                class="btn w-full bg-accent hover:bg-accent/90 text-white mt-6 gap-2">
                            <template x-if="submitting">
                                <span class="spinner"></span>
                            </template>
                            <template x-if="!submitting">
                                <i data-lucide="check" class="h-4 w-4"></i>
                            </template>
                            <span x-text="submitting ? 'Traitement...' : 'Confirmer ma commande'"></span>
                        </button>

                        <p class="text-xs text-muted-foreground text-center mt-3">
                            En confirmant, vous acceptez nos conditions générales de vente
                        </p>

                        <a href="{{ route('cart.index') }}" class="btn btn-ghost w-full mt-2">
                            <i data-lucide="arrow-left" class="h-4 w-4 mr-2"></i>
                            Retour au panier
                        </a>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection
