@extends('layouts.app')

@section('title', 'Commande confirmée - JOLI Matelas')

@section('content')
<div class="min-h-screen bg-gray-50">
    @include('partials.page-hero', [
        'title' => 'Commande confirmée',
        'breadcrumbs' => [
            ['label' => 'Accueil', 'href' => route('home')],
            ['label' => 'Commande', 'href' => route('checkout.index')],
            ['label' => 'Confirmation']
        ]
    ])

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
        <div class="max-w-2xl mx-auto">
            <!-- Success Header -->
            <div class="bg-white rounded-2xl shadow-sm p-8 text-center mb-6">
                <div class="w-20 h-20 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-6">
                    <i data-lucide="check-circle" class="h-10 w-10 text-green-600"></i>
                </div>
                <h2 class="text-2xl font-bold text-primary mb-2">Commande confirmée !</h2>
                <p class="text-muted-foreground mb-4">
                    Merci pour votre commande. Nous vous contacterons bientôt pour organiser la livraison.
                </p>
                <div class="inline-block bg-primary/10 text-primary px-4 py-2 rounded-lg font-mono font-bold">
                    {{ $order->order_number }}
                </div>
            </div>

            <!-- Order Details -->
            <div class="bg-white rounded-2xl shadow-sm p-6 mb-6">
                <h2 class="text-lg font-bold text-primary mb-4 flex items-center gap-2">
                    <i data-lucide="package" class="h-5 w-5"></i>
                    Détails de la commande
                </h2>

                <div class="space-y-4">
                    <!-- Status -->
                    <div class="flex items-center justify-between py-3 border-b">
                        <span class="text-muted-foreground">Statut</span>
                        <span class="badge bg-amber-100 text-amber-700">
                            @switch($order->status)
                                @case('EN_ATTENTE_TRAITEMENT')
                                    En attente de traitement
                                    @break
                                @case('EN_ATTENTE_LIVRAISON')
                                    En cours de livraison
                                    @break
                                @case('LIVREE')
                                    Livrée
                                    @break
                                @case('ANNULEE')
                                    Annulée
                                    @break
                                @default
                                    {{ $order->status }}
                            @endswitch
                        </span>
                    </div>

                    <!-- Date -->
                    <div class="flex items-center justify-between py-3 border-b">
                        <span class="text-muted-foreground">Date</span>
                        <span>{{ $order->created_at->format('d/m/Y à H:i') }}</span>
                    </div>

                    <!-- Store -->
                    @if($order->store)
                    <div class="flex items-center justify-between py-3 border-b">
                        <span class="text-muted-foreground">Magasin</span>
                        <span>{{ $order->store->name }}</span>
                    </div>
                    @endif

                    <!-- Items -->
                    <div class="py-3 border-b">
                        <p class="text-muted-foreground mb-3">Articles</p>
                        <div class="space-y-2">
                            @foreach($order->items as $item)
                            <div class="flex justify-between">
                                <span>
                                    {{ $item->product->name }}
                                    <span class="text-muted-foreground">({{ $item->variant->size }}) × {{ $item->quantity }}</span>
                                </span>
                                <span class="font-medium">{{ number_format($item->subtotal, 0, ',', ' ') }} {{ config('shop.currency_symbol') }}</span>
                            </div>
                            @endforeach
                        </div>
                    </div>

                    <!-- Total -->
                    <div class="flex items-center justify-between py-3 text-lg font-bold">
                        <span>Total</span>
                        <span class="text-accent">{{ number_format($order->total_amount, 0, ',', ' ') }} {{ config('shop.currency_symbol') }}</span>
                    </div>
                </div>
            </div>

            <!-- Customer Info -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                <!-- Contact -->
                <div class="bg-white rounded-xl shadow-sm p-6">
                    <h3 class="font-semibold text-primary mb-3 flex items-center gap-2">
                        <i data-lucide="user" class="h-4 w-4"></i>
                        Contact
                    </h3>
                    <p class="font-medium">{{ $order->customer_first_name }} {{ $order->customer_last_name }}</p>
                    <p class="text-muted-foreground">{{ $order->customer_phone }}</p>
                    @if($order->customer_email)
                    <p class="text-muted-foreground">{{ $order->customer_email }}</p>
                    @endif
                </div>

                <!-- Delivery Address -->
                <div class="bg-white rounded-xl shadow-sm p-6">
                    <h3 class="font-semibold text-primary mb-3 flex items-center gap-2">
                        <i data-lucide="map-pin" class="h-4 w-4"></i>
                        Adresse de livraison
                    </h3>
                    <p>{{ $order->delivery_street }}</p>
                    <p>@if($order->delivery_postal_code){{ $order->delivery_postal_code }} @endif{{ $order->delivery_city }}</p>
                </div>
            </div>

            <!-- Notes -->
            @if($order->customer_notes)
            <div class="bg-white rounded-xl shadow-sm p-6 mb-6">
                <h3 class="font-semibold text-primary mb-3 flex items-center gap-2">
                    <i data-lucide="message-square" class="h-4 w-4"></i>
                    Notes
                </h3>
                <p class="text-muted-foreground">{{ $order->customer_notes }}</p>
            </div>
            @endif

            <!-- Payment Reminder -->
            <div class="bg-amber-50 border border-amber-200 rounded-xl p-6 mb-6">
                <div class="flex items-start gap-3">
                    <i data-lucide="info" class="h-5 w-5 text-amber-600 mt-0.5"></i>
                    <div>
                        <h3 class="font-semibold text-amber-800">Paiement à la livraison</h3>
                        <p class="text-amber-700 text-sm mt-1">
                            Préparez le montant exact de <strong>{{ number_format($order->total_amount, 0, ',', ' ') }} {{ config('shop.currency_symbol') }}</strong> en espèces pour la livraison.
                        </p>
                    </div>
                </div>
            </div>

            <!-- Actions -->
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <a href="{{ route('products.index') }}" class="btn bg-primary text-white hover:bg-primary/90">
                    Continuer mes achats
                </a>
                <a href="{{ route('home') }}" class="btn btn-outline">
                    Retour à l'accueil
                </a>
            </div>
        </div>
    </div>
</div>
@endsection
