﻿@extends('layouts.admin')

@section('title', 'Utilisateurs')
@section('page-title', 'Utilisateurs')

@section('content')
<div class="bg-white rounded-lg shadow-sm p-6">
    <div class="flex items-center justify-between mb-4">
        <h2 class="text-lg font-semibold">Liste des utilisateurs</h2>
        <a href="{{ route('admin.users.create') }}" class="inline-flex items-center px-3 py-2 rounded bg-primary text-white text-sm">Nouveau</a>
    </div>

    @if($users->isEmpty())
        <p class="text-sm text-gray-600">Aucun utilisateur.</p>
    @else
        <div class="overflow-x-auto">
            <table class="min-w-full text-sm">
                <thead>
                    <tr class="text-left border-b">
                        <th class="py-2">Nom</th>
                        <th class="py-2">Email</th>
                        <th class="py-2">Rôle</th>
                        <th class="py-2">Statut</th>
                        <th class="py-2">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($users as $user)
                    <tr class="border-b">
                        <td class="py-2">{{ $user->first_name }} {{ $user->last_name }}</td>
                        <td class="py-2">{{ $user->email }}</td>
                        <td class="py-2">{{ $user->role }}</td>
                        <td class="py-2">{{ $user->is_active ? 'Actif' : 'Inactif' }}</td>
                        <td class="py-2">
                            <a href="{{ route('admin.users.edit', $user->id) }}" class="text-primary hover:underline">Modifier</a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div class="mt-4">
            {{ $users->links() }}
        </div>
    @endif
</div>
@endsection
