﻿@extends('layouts.admin')

@section('title', 'Creer un magasin')
@section('page-title', 'Magasins')

@section('content')
<div class="bg-white rounded-lg shadow-sm p-6">
    <div class="flex items-center justify-between mb-6">
        <h2 class="text-lg font-semibold">Creer un magasin</h2>
        <a href="{{ route('admin.stores.index') }}" class="text-sm text-gray-600 hover:text-primary">Retour</a>
    </div>

    @if($errors->any())
        <div class="mb-4 rounded-lg border border-red-200 bg-red-50 p-4 text-sm text-red-700">
            <ul class="list-disc pl-4 space-y-1">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    @php
        $openingHoursText = old('opening_hours');
    @endphp

    <form method="POST" action="{{ route('admin.stores.store') }}" class="space-y-6">
        @csrf

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Nom *</label>
                <input type="text" name="name" value="{{ old('name') }}" required
                       class="w-full rounded-lg border border-gray-300 px-3 py-2 text-sm">
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Telephone *</label>
                <input type="text" name="phone" value="{{ old('phone') }}" required
                       class="w-full rounded-lg border border-gray-300 px-3 py-2 text-sm">
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Email *</label>
                <input type="email" name="email" value="{{ old('email') }}" required
                       class="w-full rounded-lg border border-gray-300 px-3 py-2 text-sm">
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Pays</label>
                <input type="text" name="country" value="{{ old('country', 'France') }}"
                       class="w-full rounded-lg border border-gray-300 px-3 py-2 text-sm">
            </div>

            <div class="lg:col-span-2">
                <label class="block text-sm font-medium text-gray-700 mb-2">Description</label>
                <textarea name="description" rows="3"
                          class="w-full rounded-lg border border-gray-300 px-3 py-2 text-sm">{{ old('description') }}</textarea>
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Adresse *</label>
                <input type="text" name="street" value="{{ old('street') }}" required
                       class="w-full rounded-lg border border-gray-300 px-3 py-2 text-sm">
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Ville *</label>
                <input type="text" name="city" value="{{ old('city') }}" required
                       class="w-full rounded-lg border border-gray-300 px-3 py-2 text-sm">
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Code postal</label>
                <input type="text" name="postal_code" value="{{ old('postal_code') }}"
                       class="w-full rounded-lg border border-gray-300 px-3 py-2 text-sm">
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Latitude</label>
                <input type="text" name="latitude" value="{{ old('latitude') }}"
                       class="w-full rounded-lg border border-gray-300 px-3 py-2 text-sm">
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Longitude</label>
                <input type="text" name="longitude" value="{{ old('longitude') }}"
                       class="w-full rounded-lg border border-gray-300 px-3 py-2 text-sm">
            </div>

            <div class="lg:col-span-2">
                <label class="block text-sm font-medium text-gray-700 mb-2">Horaires</label>
                <textarea name="opening_hours" rows="4" placeholder="Lundi: 09:00-18:00"
                          class="w-full rounded-lg border border-gray-300 px-3 py-2 text-sm">{{ $openingHoursText }}</textarea>
                <p class="text-xs text-gray-500 mt-1">Format: une ligne par jour (ex: Lundi: 09:00-18:00) ou JSON.</p>
            </div>

            <div class="lg:col-span-2">
                <label class="inline-flex items-center gap-3">
                    <input type="checkbox" name="is_active" value="1" {{ old('is_active', true) ? 'checked' : '' }}
                           class="h-4 w-4 rounded border-gray-300 text-primary">
                    <span class="text-sm text-gray-700">Magasin actif</span>
                </label>
            </div>
        </div>

        <div class="flex items-center justify-end gap-3">
            <a href="{{ route('admin.stores.index') }}"
               class="px-4 py-2 text-sm text-gray-600 hover:text-primary">Annuler</a>
            <button type="submit"
                    class="px-4 py-2 text-sm font-medium text-white bg-primary rounded-lg hover:bg-primary/90">Creer</button>
        </div>
    </form>
</div>
@endsection
