﻿@extends('layouts.admin')

@section('title', 'Mouvements de stock')
@section('page-title', 'Stock')

@section('content')
<div class="bg-white rounded-lg shadow-sm p-6">
    <div class="flex items-center justify-between mb-6">
        <h2 class="text-lg font-semibold">Mouvements de stock</h2>
        <a href="{{ route('admin.stock.index') }}" class="text-sm text-gray-600 hover:text-primary">Retour au stock</a>
    </div>

    @if($errors->any())
        <div class="mb-4 rounded-lg border border-red-200 bg-red-50 p-4 text-sm text-red-700">
            <ul class="list-disc pl-4 space-y-1">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="border rounded-lg p-4 mb-6">
        <h3 class="text-base font-semibold mb-3">Creer un mouvement</h3>
        <form method="POST" action="{{ route('admin.stock.movements.store') }}" class="space-y-4">
            @csrf
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Magasin *</label>
                    <select name="store_id" required class="w-full rounded-lg border border-gray-300 px-3 py-2 text-sm">
                        <option value="">Selectionner</option>
                        @foreach($stores as $store)
                            <option value="{{ $store->id }}" {{ (string)old('store_id') === (string)$store->id ? 'selected' : '' }}>{{ $store->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Produit *</label>
                    <select name="product_id" required class="w-full rounded-lg border border-gray-300 px-3 py-2 text-sm">
                        <option value="">Selectionner</option>
                        @foreach($products as $product)
                            <option value="{{ $product->id }}" {{ (string)old('product_id') === (string)$product->id ? 'selected' : '' }}>{{ $product->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Variante *</label>
                    <select name="variant_id" required class="w-full rounded-lg border border-gray-300 px-3 py-2 text-sm">
                        <option value="">Selectionner</option>
                        @foreach($variants as $variant)
                            @php
                                $variantLabel = ($variant->product->name ?? 'Produit') . ' - ' . ($variant->size ?? ($variant->name ?? ('Variante #' . $variant->id)));
                            @endphp
                            <option value="{{ $variant->id }}" {{ (string)old('variant_id') === (string)$variant->id ? 'selected' : '' }}>{{ $variantLabel }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Type *</label>
                    <select name="type" required class="w-full rounded-lg border border-gray-300 px-3 py-2 text-sm">
                        <option value="">Selectionner</option>
                        <option value="IN" {{ old('type') === 'IN' ? 'selected' : '' }}>IN</option>
                        <option value="OUT" {{ old('type') === 'OUT' ? 'selected' : '' }}>OUT</option>
                        <option value="ADJUSTMENT" {{ old('type') === 'ADJUSTMENT' ? 'selected' : '' }}>ADJUSTMENT</option>
                    </select>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Quantite *</label>
                    <input type="number" name="quantity" value="{{ old('quantity') }}" class="w-full rounded-lg border border-gray-300 px-3 py-2 text-sm" required>
                    <p class="text-xs text-gray-500 mt-1">Pour ADJUSTMENT, la quantite peut etre negative.</p>
                </div>
                <div class="md:col-span-3">
                    <label class="block text-sm font-medium text-gray-700 mb-2">Commentaire</label>
                    <textarea name="reason" rows="2" class="w-full rounded-lg border border-gray-300 px-3 py-2 text-sm">{{ old('reason') }}</textarea>
                </div>
            </div>
            <div class="flex items-center justify-end">
                <button type="submit" class="px-4 py-2 text-sm font-medium text-white bg-primary rounded-lg hover:bg-primary/90">Creer</button>
            </div>
        </form>
    </div>

    <form method="GET" action="{{ route('admin.stock.movements.index') }}" class="mb-4">
        <div class="grid grid-cols-1 md:grid-cols-6 gap-3">
            <div>
                <label class="text-xs text-gray-600" for="filter_store_id">Magasin</label>
                <select id="filter_store_id" name="store_id" class="w-full border rounded px-2 py-2 text-sm">
                    <option value="">Tous</option>
                    @foreach($stores as $store)
                        <option value="{{ $store->id }}" {{ (string)($currentFilters['store_id'] ?? '') === (string)$store->id ? 'selected' : '' }}>{{ $store->name }}</option>
                    @endforeach
                </select>
            </div>
            <div>
                <label class="text-xs text-gray-600" for="filter_product_id">Produit</label>
                <select id="filter_product_id" name="product_id" class="w-full border rounded px-2 py-2 text-sm">
                    <option value="">Tous</option>
                    @foreach($products as $product)
                        <option value="{{ $product->id }}" {{ (string)($currentFilters['product_id'] ?? '') === (string)$product->id ? 'selected' : '' }}>{{ $product->name }}</option>
                    @endforeach
                </select>
            </div>
            <div>
                <label class="text-xs text-gray-600" for="filter_type">Type</label>
                <select id="filter_type" name="type" class="w-full border rounded px-2 py-2 text-sm">
                    <option value="">Tous</option>
                    <option value="IN" {{ ($currentFilters['type'] ?? '') === 'IN' ? 'selected' : '' }}>IN</option>
                    <option value="OUT" {{ ($currentFilters['type'] ?? '') === 'OUT' ? 'selected' : '' }}>OUT</option>
                    <option value="ADJUSTMENT" {{ ($currentFilters['type'] ?? '') === 'ADJUSTMENT' ? 'selected' : '' }}>ADJUSTMENT</option>
                    <option value="TRANSFER" {{ ($currentFilters['type'] ?? '') === 'TRANSFER' ? 'selected' : '' }}>TRANSFER</option>
                </select>
            </div>
            <div>
                <label class="text-xs text-gray-600" for="filter_date_from">Date debut</label>
                <input id="filter_date_from" type="date" name="date_from" value="{{ $currentFilters['date_from'] ?? '' }}" class="w-full border rounded px-2 py-2 text-sm">
            </div>
            <div>
                <label class="text-xs text-gray-600" for="filter_date_to">Date fin</label>
                <input id="filter_date_to" type="date" name="date_to" value="{{ $currentFilters['date_to'] ?? '' }}" class="w-full border rounded px-2 py-2 text-sm">
            </div>
            <div class="flex items-end gap-2">
                <button type="submit" class="inline-flex items-center px-3 py-2 rounded bg-gray-800 text-white text-sm">Filtrer</button>
                <a href="{{ route('admin.stock.movements.index') }}" class="inline-flex items-center px-3 py-2 rounded border text-sm">Reinitialiser</a>
            </div>
        </div>
    </form>

    @if($movements->isEmpty())
        <p class="text-sm text-gray-600">Aucun mouvement.</p>
    @else
        <div class="overflow-x-auto">
            <table class="min-w-full text-sm">
                <thead>
                    <tr class="text-left border-b">
                        <th class="py-2">Date / heure</th>
                        <th class="py-2">Magasin</th>
                        <th class="py-2">Produit</th>
                        <th class="py-2">Variante</th>
                        <th class="py-2">Type</th>
                        <th class="py-2">Quantite</th>
                        <th class="py-2">Source</th>
                        <th class="py-2">Commentaire</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($movements as $movement)
                        @php
                            $rawQty = (int)$movement->quantity;
                            $displayQty = $rawQty;
                            if ($movement->type === 'OUT' && $rawQty > 0) {
                                $displayQty = -$rawQty;
                            }
                            if ($movement->type === 'IN' && $rawQty < 0) {
                                $displayQty = abs($rawQty);
                            }
                            $qtyClass = $displayQty < 0 ? 'text-red-600' : 'text-green-600';
                            $reason = $movement->reason ?? '';
                            $source = 'Manuel';
                            if ($reason !== '' && str_starts_with($reason, 'Commande #')) {
                                $source = 'Commande';
                            } elseif ($movement->type === 'IN') {
                                $source = 'Achat';
                            } elseif ($movement->type === 'OUT') {
                                $source = 'Sortie';
                            } elseif ($movement->type === 'ADJUSTMENT') {
                                $source = 'Ajustement manuel';
                            } elseif ($movement->type === 'TRANSFER') {
                                $source = 'Transfert';
                            }
                            $stockItem = $movement->stockItem;
                            $storeName = ($stockItem && $stockItem->store) ? $stockItem->store->name : '-';
                            $productName = ($stockItem && $stockItem->product) ? $stockItem->product->name : '-';
                            $variantLabel = '-';
                            if ($stockItem && $stockItem->variant) {
                                $variantLabel = $stockItem->variant->size ?? ($stockItem->variant->name ?? '-');
                            }
                        @endphp
                        <tr class="border-b">
                            <td class="py-2">{{ $movement->created_at ? $movement->created_at->format('d/m/Y H:i') : '-' }}</td>
                            <td class="py-2">{{ $storeName }}</td>
                            <td class="py-2">{{ $productName }}</td>
                            <td class="py-2">{{ $variantLabel }}</td>
                            <td class="py-2">{{ $movement->type }}</td>
                            <td class="py-2"><span class="font-semibold {{ $qtyClass }}">{{ $displayQty }}</span></td>
                            <td class="py-2">{{ $source }}</td>
                            <td class="py-2">{{ $reason !== '' ? $reason : '-' }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div class="mt-4">
            {{ $movements->links() }}
        </div>
    @endif
</div>
@endsection
