﻿@extends('layouts.admin')

@section('title', 'Nouvel inventaire')
@section('page-title', 'Stock')

@section('content')
<div class="bg-white rounded-lg shadow-sm p-6">
    <div class="flex items-center justify-between mb-6">
        <h2 class="text-lg font-semibold">Nouvel inventaire</h2>
        <a href="{{ route('admin.stock.inventories.index') }}" class="text-sm text-gray-600 hover:text-primary">Retour</a>
    </div>

    @if($errors->any())
        <div class="mb-4 rounded-lg border border-red-200 bg-red-50 p-4 text-sm text-red-700">
            <ul class="list-disc pl-4 space-y-1">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form method="POST" action="{{ route('admin.stock.inventories.store') }}" class="space-y-4">
        @csrf
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Magasin *</label>
                <select name="store_id" required class="w-full rounded-lg border border-gray-300 px-3 py-2 text-sm">
                    <option value="">Selectionner</option>
                    @foreach($stores as $store)
                        <option value="{{ $store->id }}" {{ (string)old('store_id') === (string)$store->id ? 'selected' : '' }}>{{ $store->name }}</option>
                    @endforeach
                </select>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Mois *</label>
                <input type="month" name="month" value="{{ old('month', $defaultMonth) }}"
                       class="w-full rounded-lg border border-gray-300 px-3 py-2 text-sm" required>
            </div>
        </div>
        <div class="flex items-center justify-end gap-3">
            <a href="{{ route('admin.stock.inventories.index') }}" class="px-4 py-2 text-sm text-gray-600 hover:text-primary">Annuler</a>
            <button type="submit" class="px-4 py-2 text-sm font-medium text-white bg-primary rounded-lg hover:bg-primary/90">Creer</button>
        </div>
    </form>
</div>
@endsection
