﻿@extends('layouts.admin')

@section('title', 'Stock')
@section('page-title', 'Stock')

@section('content')
<div class="bg-white rounded-lg shadow-sm p-6">
    <div class="flex items-center justify-between mb-4">
        <h2 class="text-lg font-semibold">Stock</h2>
        <a href="{{ route('admin.stock.create') }}" class="inline-flex items-center px-3 py-2 rounded bg-primary text-white text-sm">Nouveau</a>
    </div>

    <form method="GET" action="{{ route('admin.stock.index') }}" class="mb-6">
        <div class="grid grid-cols-1 md:grid-cols-5 gap-3">
            <div>
                <label for="store_id" class="text-xs text-gray-600">Magasin</label>
                <select id="store_id" name="store_id" class="w-full border rounded px-2 py-2 text-sm">
                    <option value="">Tous les magasins</option>
                    @foreach($stores as $store)
                        <option value="{{ $store->id }}" {{ (string)($currentFilters['store_id'] ?? '') === (string)$store->id ? 'selected' : '' }}>{{ $store->name }}</option>
                    @endforeach
                </select>
            </div>
            <div>
                <label for="product_id" class="text-xs text-gray-600">Produit</label>
                <select id="product_id" name="product_id" class="w-full border rounded px-2 py-2 text-sm">
                    <option value="">Tous les produits</option>
                    @foreach($products as $product)
                        <option value="{{ $product->id }}" {{ (string)($currentFilters['product_id'] ?? '') === (string)$product->id ? 'selected' : '' }}>{{ $product->name }}</option>
                    @endforeach
                </select>
            </div>
            <div>
                <label for="category_id" class="text-xs text-gray-600">Catégorie</label>
                <select id="category_id" name="category_id" class="w-full border rounded px-2 py-2 text-sm">
                    <option value="">Toutes les catégories</option>
                    @foreach($categories as $category)
                        <option value="{{ $category->id }}" {{ (string)($currentFilters['category_id'] ?? '') === (string)$category->id ? 'selected' : '' }}>{{ $category->name }}</option>
                    @endforeach
                </select>
            </div>
            <div class="flex items-end">
                <label class="inline-flex items-center gap-2 text-sm">
                    <input type="checkbox" name="low_stock" value="1" class="rounded border-gray-300" {{ !empty($currentFilters['low_stock']) ? 'checked' : '' }}>
                    Stock faible
                </label>
            </div>
            <div class="flex items-end gap-2">
                <button type="submit" class="inline-flex items-center px-3 py-2 rounded bg-gray-800 text-white text-sm">Filtrer</button>
                <a href="{{ route('admin.stock.index') }}" class="inline-flex items-center px-3 py-2 rounded border text-sm">Réinitialiser</a>
            </div>
        </div>
    </form>

    @if(!empty($stats))
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
            <div class="p-3 bg-gray-50 rounded">Total items: {{ $stats['total_items'] }}</div>
            <div class="p-3 bg-gray-50 rounded">Quantité: {{ $stats['total_quantity'] }}</div>
            <div class="p-3 bg-gray-50 rounded">Réservé: {{ $stats['total_reserved'] }}</div>
            <div class="p-3 bg-gray-50 rounded">Stock faible: {{ $stats['low_stock_count'] }}</div>
        </div>
    @endif

    <div class="mb-6">
        <h3 class="text-base font-semibold mb-2">Vue par magasin</h3>
        @if($stockItems->isEmpty())
            <p class="text-sm text-gray-600">Aucun stock.</p>
        @else
            <div class="overflow-x-auto">
                <table class="min-w-full text-sm">
                    <thead>
                        <tr class="text-left border-b">
                            <th class="py-2">Magasin</th>
                            <th class="py-2">Produit</th>
                            <th class="py-2">Variante</th>
                            <th class="py-2">Stock disponible</th>
                            <th class="py-2">Stock réservé</th>
                            <th class="py-2">Stock total</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($stockItems as $item)
                            @php
                                $available = (int)$item->quantity - (int)$item->reserved_quantity;
                                $threshold = (int)($item->alert_threshold ?? 0);
                                $availableClass = 'text-green-600';
                                if ($available <= 0) {
                                    $availableClass = 'text-red-600';
                                } elseif ($available <= $threshold) {
                                    $availableClass = 'text-orange-600';
                                }
                            @endphp
                            <tr class="border-b">
                                <td class="py-2">{{ optional($item->store)->name ?? '-' }}</td>
                                <td class="py-2">{{ optional($item->product)->name ?? '-' }}</td>
                                <td class="py-2">{{ optional($item->variant)->size ?? (optional($item->variant)->name ?? '-') }}</td>
                                <td class="py-2">
                                    <span class="font-semibold {{ $availableClass }}">{{ $available }}</span>
                                </td>
                                <td class="py-2">{{ $item->reserved_quantity }}</td>
                                <td class="py-2">{{ $item->quantity }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <div class="mt-4">
                {{ $stockItems->links() }}
            </div>
        @endif
    </div>

    <div>
        <h3 class="text-base font-semibold mb-2">Vue globale</h3>
        @if($globalStock->isEmpty())
            <p class="text-sm text-gray-600">Aucun stock global.</p>
        @else
            <div class="overflow-x-auto">
                <table class="min-w-full text-sm">
                    <thead>
                        <tr class="text-left border-b">
                            <th class="py-2">Produit</th>
                            <th class="py-2">Variante</th>
                            <th class="py-2">Stock total</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($globalStock as $row)
                            @php
                                $totalAvailable = (int)$row->total_available;
                                $threshold = (int)($row->min_alert_threshold ?? 0);
                                $totalClass = 'text-green-600';
                                if ($totalAvailable <= 0) {
                                    $totalClass = 'text-red-600';
                                } elseif ($totalAvailable <= $threshold) {
                                    $totalClass = 'text-orange-600';
                                }
                                $product = $globalProducts[$row->product_id] ?? null;
                                $variant = $globalVariants[$row->variant_id] ?? null;
                                $productName = $product ? $product->name : '-';
                                $variantName = $variant ? ($variant->size ?? ($variant->name ?? '-')) : '-';
                            @endphp
                            <tr class="border-b">
                                <td class="py-2">{{ $productName }}</td>
                                <td class="py-2">{{ $variantName }}</td>
                                <td class="py-2">
                                    <div class="font-semibold {{ $totalClass }}">{{ $row->total_quantity }}</div>
                                    <div class="text-xs text-gray-500">Disponible: {{ $row->total_available }} · Réservé: {{ $row->total_reserved }}</div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @endif
    </div>
</div>
@endsection
