@extends('layouts.admin')

@section('title', 'Services connexes')
@section('page-title', 'Services connexes')

@section('content')
<div class="bg-white rounded-lg shadow-sm p-6">
    <div class="flex items-center justify-between mb-6">
        <h2 class="text-lg font-semibold">Liste des services</h2>
        <a href="{{ route('admin.services.create') }}"
           class="inline-flex items-center gap-2 px-4 py-2 rounded-lg bg-primary text-white text-sm hover:bg-primary/90">
            <i data-lucide="plus" class="h-4 w-4"></i>
            Nouveau service
        </a>
    </div>

    <form action="{{ route('admin.services.index') }}" method="GET" class="flex flex-wrap gap-3 mb-6">
        <input type="text" name="search" value="{{ $currentFilters['search'] ?? '' }}"
               placeholder="Rechercher par titre..."
               class="px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-primary focus:border-transparent">
        <button type="submit" class="px-4 py-2 bg-gray-100 text-gray-700 rounded-lg text-sm hover:bg-gray-200">Filtrer</button>
        @if(!empty($currentFilters['search']))
            <a href="{{ route('admin.services.index') }}" class="px-4 py-2 text-gray-500 text-sm hover:text-gray-700">Reinitialiser</a>
        @endif
    </form>

    @if($services->isEmpty())
        <p class="text-sm text-gray-600">Aucun service.</p>
    @else
        <div class="overflow-x-auto">
            <table class="min-w-full text-sm">
                <thead>
                    <tr class="text-left border-b bg-gray-50">
                        <th class="px-4 py-3 font-medium text-gray-600">Titre</th>
                        <th class="px-4 py-3 font-medium text-gray-600">Statut</th>
                        <th class="px-4 py-3 font-medium text-gray-600">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y">
                    @foreach($services as $service)
                    <tr class="hover:bg-gray-50">
                        <td class="px-4 py-3 font-medium">{{ $service->title }}</td>
                        <td class="px-4 py-3">
                            <form action="{{ route('admin.services.toggle', $service->id) }}" method="POST" class="inline">
                                @csrf
                                <button type="submit"
                                        class="px-2 py-1 text-xs rounded-full {{ $service->is_active ? 'bg-green-100 text-green-700' : 'bg-gray-100 text-gray-600' }}">
                                    {{ $service->is_active ? 'Actif' : 'Inactif' }}
                                </button>
                            </form>
                        </td>
                        <td class="px-4 py-3">
                            <div class="flex items-center gap-3">
                                <a href="{{ route('admin.services.edit', $service->id) }}"
                                   class="text-primary hover:underline text-sm">Modifier</a>
                                <form action="{{ route('admin.services.destroy', $service->id) }}" method="POST"
                                      onsubmit="return confirm('Supprimer ce service ?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="text-red-600 hover:underline text-sm">Supprimer</button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div class="mt-4">
            {{ $services->links() }}
        </div>
    @endif
</div>
@endsection
