﻿@extends('layouts.admin')

@section('title', 'Produits')
@section('page-title', 'Produits')

@section('content')
<div class="bg-white rounded-lg shadow-sm p-6">
    <div class="flex items-center justify-between mb-4">
        <h2 class="text-lg font-semibold">Liste des produits</h2>
        <a href="{{ route('admin.products.create') }}" class="inline-flex items-center px-3 py-2 rounded bg-primary text-white text-sm">Nouveau</a>
    </div>

    @if($products->isEmpty())
        <p class="text-sm text-gray-600">Aucun produit.</p>
    @else
        <div class="overflow-x-auto">
            <table class="min-w-full text-sm">
                <thead>
                    <tr class="text-left border-b">
                        <th class="py-2">Produit</th>
                        <th class="py-2">Catégorie</th>
                        <th class="py-2">Prix</th>
                        <th class="py-2">Statut</th>
                        <th class="py-2">Favori</th>
                        <th class="py-2">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($products as $product)
                    <tr class="border-b">
                        <td class="py-2">{{ $product->name }}</td>
                        <td class="py-2">{{ $product->category->name ?? '-' }}</td>
                        <td class="py-2">{{ number_format($product->base_price, 2, ',', ' ') }}</td>
                        <td class="py-2">{{ $product->is_active ? 'Actif' : 'Inactif' }}</td>
                        <td class="py-2">
                            <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium {{ $product->is_featured ? 'bg-amber-100 text-amber-700' : 'bg-gray-100 text-gray-600' }}">
                                {{ $product->is_featured ? 'Oui' : 'Non' }}
                            </span>
                        </td>
                        <td class="py-2">
                            <a href="{{ route('admin.products.edit', $product->id) }}" class="text-primary hover:underline">Modifier</a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div class="mt-4">
            {{ $products->links() }}
        </div>
    @endif
</div>
@endsection
