@extends('layouts.admin')

@section('title', 'Attributs produits')
@section('page-title', 'Attributs produits')

@section('content')
<div class="bg-white rounded-lg shadow-sm p-6">
    <div class="flex items-center justify-between mb-6">
        <h2 class="text-lg font-semibold">Liste des attributs</h2>
        <a href="{{ route('admin.product-attributes.create') }}"
           class="inline-flex items-center gap-2 px-4 py-2 rounded-lg bg-primary text-white text-sm hover:bg-primary/90">
            <i data-lucide="plus" class="h-4 w-4"></i>
            Nouvel attribut
        </a>
    </div>

    @if($attributes->isEmpty())
        <p class="text-sm text-gray-600">Aucun attribut.</p>
    @else
        <div class="overflow-x-auto">
            <table class="min-w-full text-sm">
                <thead>
                    <tr class="text-left border-b bg-gray-50">
                        <th class="px-4 py-3 font-medium text-gray-600">Nom</th>
                        <th class="px-4 py-3 font-medium text-gray-600">Type</th>
                        <th class="px-4 py-3 font-medium text-gray-600">Obligatoire</th>
                        <th class="px-4 py-3 font-medium text-gray-600">Categories</th>
                        <th class="px-4 py-3 font-medium text-gray-600">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y">
                    @foreach($attributes as $attribute)
                    <tr class="hover:bg-gray-50">
                        <td class="px-4 py-3 font-medium">{{ $attribute->name }}</td>
                        <td class="px-4 py-3 text-gray-600">{{ ucfirst($attribute->type) }}</td>
                        <td class="px-4 py-3">
                            <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium {{ $attribute->required ? 'bg-green-100 text-green-700' : 'bg-gray-100 text-gray-600' }}">
                                {{ $attribute->required ? 'Oui' : 'Non' }}
                            </span>
                        </td>
                        <td class="px-4 py-3 text-gray-600">
                            @if($attribute->categories->isEmpty())
                                <span class="text-xs text-gray-400">Aucune</span>
                            @else
                                {{ $attribute->categories->pluck('name')->join(', ') }}
                            @endif
                        </td>
                        <td class="px-4 py-3">
                            <div class="flex items-center gap-3">
                                <a href="{{ route('admin.product-attributes.edit', $attribute->id) }}"
                                   class="text-primary hover:underline text-sm">Modifier</a>
                                <form action="{{ route('admin.product-attributes.destroy', $attribute->id) }}" method="POST"
                                      onsubmit="return confirm('Supprimer cet attribut ?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="text-red-600 hover:underline text-sm">Supprimer</button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div class="mt-4">
            {{ $attributes->links() }}
        </div>
    @endif
</div>
@endsection
