@extends('layouts.admin')

@section('title', 'Commande ' . $order->order_number)
@section('page-title', 'Commande ' . $order->order_number)

@section('content')
<div class="space-y-6">
    <!-- Summary -->
    <div class="bg-white rounded-xl shadow-sm p-6">
        <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between gap-4">
            <div>
                <p class="text-sm text-gray-500">Référence</p>
                <p class="text-lg font-semibold font-mono">{{ $order->order_number }}</p>
            </div>
            <div>
                <p class="text-sm text-gray-500">Statut</p>
                <span class="inline-flex items-center px-3 py-1 rounded-full text-sm
                    @if($order->status === 'EN_ATTENTE_TRAITEMENT') bg-amber-100 text-amber-700
                    @elseif($order->status === 'EN_ATTENTE_LIVRAISON') bg-blue-100 text-blue-700
                    @elseif($order->status === 'LIVREE') bg-green-100 text-green-700
                    @else bg-gray-100 text-gray-700
                    @endif">
                    {{ $statuses[$order->status] ?? $order->status }}
                </span>
            </div>
            <div>
                <p class="text-sm text-gray-500">Date</p>
                <p class="text-sm font-medium">{{ $order->created_at->format('d/m/Y H:i') }}</p>
            </div>
            <div>
                <p class="text-sm text-gray-500">Total</p>
                <p class="text-lg font-semibold">{{ number_format($order->total_amount, 0, ',', ' ') }} {{ config('shop.currency_symbol') }}</p>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Order details -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Customer & delivery -->
            <div class="bg-white rounded-xl shadow-sm p-6">
                <h2 class="text-lg font-bold mb-4">Client & Livraison</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <p class="text-sm text-gray-500">Client</p>
                        <p class="font-medium">{{ $order->customer_first_name }} {{ $order->customer_last_name }}</p>
                        <p class="text-sm text-gray-600">{{ $order->customer_phone }}</p>
                        @if($order->customer_email)
                            <p class="text-sm text-gray-600">{{ $order->customer_email }}</p>
                        @endif
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Adresse</p>
                        <p class="text-sm">{{ $order->delivery_street }}</p>
                        <p class="text-sm">@if($order->delivery_postal_code){{ $order->delivery_postal_code }} @endif{{ $order->delivery_city }}</p>
                        <p class="text-sm">{{ $order->delivery_country }}</p>
                    </div>
                </div>

                @if($order->customer_notes)
                    <div class="mt-4 border-t pt-4">
                        <p class="text-sm text-gray-500">Notes client</p>
                        <p class="text-sm">{{ $order->customer_notes }}</p>
                    </div>
                @endif

                @if($order->admin_notes)
                    <div class="mt-4 border-t pt-4">
                        <p class="text-sm text-gray-500">Notes admin</p>
                        <p class="text-sm">{{ $order->admin_notes }}</p>
                    </div>
                @endif

                @if($order->fulfillmentSource)
                    <div class="mt-4 border-t pt-4">
                        <p class="text-sm text-gray-500">Source de prélèvement</p>
                        <p class="font-medium">
                            {{ $order->fulfillmentSource->name }}
                            <span class="text-xs px-2 py-0.5 rounded-full ml-1
                                @if($order->fulfillmentSource->type === 'STORE') bg-blue-100 text-blue-700
                                @elseif($order->fulfillmentSource->type === 'FACTORY') bg-purple-100 text-purple-700
                                @elseif($order->fulfillmentSource->type === 'PARTNER') bg-amber-100 text-amber-700
                                @else bg-gray-100 text-gray-700
                                @endif">
                                {{ $order->fulfillmentSource->type }}
                            </span>
                        </p>
                        @if($order->fulfillment_note)
                            <p class="text-sm text-gray-600 mt-1">{{ $order->fulfillment_note }}</p>
                        @endif
                    </div>
                @endif
            </div>

            <!-- Items -->
            <div class="bg-white rounded-xl shadow-sm p-6">
                <h2 class="text-lg font-bold mb-4">Articles</h2>
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="border-b bg-gray-50">
                            <tr>
                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Produit</th>
                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Variante</th>
                                <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase">Qté</th>
                                <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase">Prix</th>
                                <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase">Sous-total</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y">
                            @foreach($order->items as $item)
                                <tr>
                                    <td class="px-4 py-2 text-sm">{{ $item->product_name }}</td>
                                    <td class="px-4 py-2 text-sm">{{ $item->variant_size }}</td>
                                    <td class="px-4 py-2 text-sm text-right">{{ $item->quantity }}</td>
                                    <td class="px-4 py-2 text-sm text-right">{{ number_format($item->unit_price, 0, ',', ' ') }} {{ config('shop.currency_symbol') }}</td>
                                    <td class="px-4 py-2 text-sm text-right font-medium">{{ number_format($item->subtotal, 0, ',', ' ') }} {{ config('shop.currency_symbol') }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot class="border-t">
                            <tr>
                                <td colspan="4" class="px-4 py-2 text-right text-sm text-gray-500">Sous-total</td>
                                <td class="px-4 py-2 text-right text-sm">{{ number_format($order->subtotal, 0, ',', ' ') }} {{ config('shop.currency_symbol') }}</td>
                            </tr>
                            <tr>
                                <td colspan="4" class="px-4 py-2 text-right text-sm text-gray-500">TVA</td>
                                <td class="px-4 py-2 text-right text-sm">{{ number_format($order->tax_amount, 0, ',', ' ') }} {{ config('shop.currency_symbol') }}</td>
                            </tr>
                            <tr>
                                <td colspan="4" class="px-4 py-2 text-right text-sm text-gray-500">Livraison</td>
                                <td class="px-4 py-2 text-right text-sm">{{ number_format($order->shipping_cost, 0, ',', ' ') }} {{ config('shop.currency_symbol') }}</td>
                            </tr>
                            <tr>
                                <td colspan="4" class="px-4 py-2 text-right text-sm font-semibold">Total</td>
                                <td class="px-4 py-2 text-right text-sm font-semibold">{{ number_format($order->total_amount, 0, ',', ' ') }} {{ config('shop.currency_symbol') }}</td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>

            <!-- Status history -->
            <div class="bg-white rounded-xl shadow-sm p-6">
                <h2 class="text-lg font-bold mb-4">Historique des statuts</h2>
                @if($order->statusHistory->isEmpty())
                    <p class="text-sm text-gray-500">Aucun historique disponible.</p>
                @else
                    <div class="overflow-x-auto">
                        <table class="w-full">
                            <thead class="border-b bg-gray-50">
                                <tr>
                                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Ancien statut</th>
                                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Nouveau statut</th>
                                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Commentaire</th>
                                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Par</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y">
                                @foreach($order->statusHistory->sortByDesc('created_at') as $history)
                                    <tr>
                                        <td class="px-4 py-2 text-sm">{{ $history->created_at?->format('d/m/Y H:i') }}</td>
                                        <td class="px-4 py-2 text-sm">{{ $statuses[$history->old_status] ?? $history->old_status ?? '-' }}</td>
                                        <td class="px-4 py-2 text-sm">{{ $statuses[$history->new_status] ?? $history->new_status }}</td>
                                        <td class="px-4 py-2 text-sm">{{ $history->comment ?? '-' }}</td>
                                        <td class="px-4 py-2 text-sm">
                                            {{ $history->changedBy?->first_name ?? 'System' }}
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @endif
            </div>
        </div>

        <!-- Status update -->
        <div class="lg:col-span-1">
            <div class="bg-white rounded-xl shadow-sm p-6 sticky top-24" x-data="{ selectedStatus: '{{ $order->status }}' }">
                <h2 class="text-lg font-bold mb-4">Changer le statut</h2>
                <form action="{{ route('admin.orders.updateStatus', $order->id) }}" method="POST" class="space-y-4">
                    @csrf
                    <div>
                        <label class="block text-sm font-medium mb-1">Statut</label>
                        <select name="status" x-model="selectedStatus" class="w-full px-3 py-2 border rounded-lg">
                            @foreach($statuses as $key => $label)
                                <option value="{{ $key }}" {{ $order->status === $key ? 'selected' : '' }}>
                                    {{ $label }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div x-show="selectedStatus === 'EN_ATTENTE_LIVRAISON' || selectedStatus === 'LIVREE'" x-cloak>
                        <label class="block text-sm font-medium mb-1">
                            Source de prélèvement <span class="text-red-500">*</span>
                        </label>
                        <select name="fulfillment_source_id" class="w-full px-3 py-2 border rounded-lg @error('fulfillment_source_id') border-red-500 @enderror">
                            <option value="">Sélectionner une source</option>
                            @foreach($fulfillmentSources as $source)
                                <option value="{{ $source->id }}" {{ $order->fulfillment_source_id == $source->id ? 'selected' : '' }}>
                                    {{ $source->name }} ({{ $source->type }})
                                </option>
                            @endforeach
                        </select>
                        @error('fulfillment_source_id')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div x-show="selectedStatus === 'EN_ATTENTE_LIVRAISON' || selectedStatus === 'LIVREE'" x-cloak>
                        <label class="block text-sm font-medium mb-1">Note de prélèvement</label>
                        <textarea name="fulfillment_note" rows="2" class="w-full px-3 py-2 border rounded-lg text-sm"
                                  placeholder="Ex: pris chez partenaire X...">{{ $order->fulfillment_note }}</textarea>
                    </div>

                    <div>
                        <label class="block text-sm font-medium mb-1">Commentaire</label>
                        <textarea name="notes" rows="3" class="w-full px-3 py-2 border rounded-lg"
                                  placeholder="Commentaire interne..."></textarea>
                    </div>
                    <button type="submit" class="w-full px-4 py-2 bg-primary text-white rounded-lg hover:bg-blue-900">
                        Mettre à jour
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
