@extends('layouts.admin')

@section('title', 'Commandes')
@section('page-title', 'Gestion des Commandes')

@section('content')
<div class="space-y-6">
    <!-- Filters -->
    <div class="bg-white rounded-xl shadow-sm p-6">
        <form action="{{ route('admin.orders.index') }}" method="GET" class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <div>
                <label class="block text-sm font-medium mb-1">Recherche</label>
                <input type="text" name="search" value="{{ $currentFilters['search'] ?? '' }}"
                       placeholder="Référence, nom, téléphone..."
                       class="w-full px-3 py-2 border rounded-lg">
            </div>

            <div>
                <label class="block text-sm font-medium mb-1">Statut</label>
                <select name="status" class="w-full px-3 py-2 border rounded-lg">
                    <option value="">Tous</option>
                    @foreach($statuses as $key => $label)
                        <option value="{{ $key }}" {{ ($currentFilters['status'] ?? '') == $key ? 'selected' : '' }}>
                            {{ $label }}
                        </option>
                    @endforeach
                </select>
            </div>

            <div>
                <label class="block text-sm font-medium mb-1">Magasin</label>
                <select name="store_id" class="w-full px-3 py-2 border rounded-lg">
                    <option value="">Tous</option>
                    @foreach($stores as $store)
                        <option value="{{ $store->id }}" {{ ($currentFilters['store_id'] ?? '') == $store->id ? 'selected' : '' }}>
                            {{ $store->name }}
                        </option>
                    @endforeach
                </select>
            </div>

            <div class="flex items-end gap-2">
                <button type="submit" class="px-4 py-2 bg-primary text-white rounded-lg hover:bg-blue-900">
                    Filtrer
                </button>
                <a href="{{ route('admin.orders.index') }}" class="px-4 py-2 border rounded-lg hover:bg-gray-50">
                    Réinitialiser
                </a>
            </div>
        </form>
    </div>

    <!-- Orders Table -->
    <div class="bg-white rounded-xl shadow-sm overflow-hidden">
        @if($orders->isEmpty())
            <div class="text-center py-12">
                <i data-lucide="inbox" class="h-16 w-16 mx-auto text-gray-300 mb-4"></i>
                <p class="text-gray-500">Aucune commande trouvée</p>
            </div>
        @else
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-gray-50 border-b">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Référence</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Client</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Magasin</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Montant</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Statut</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y">
                        @foreach($orders as $order)
                        <tr class="hover:bg-gray-50">
                            <td class="px-6 py-4 font-mono text-sm">{{ $order->order_number }}</td>
                            <td class="px-6 py-4">
                                <div class="text-sm font-medium">{{ $order->customer_first_name }} {{ $order->customer_last_name }}</div>
                                <div class="text-xs text-gray-500">{{ $order->customer_phone }}</div>
                            </td>
                            <td class="px-6 py-4 text-sm">{{ $order->store->name ?? '-' }}</td>
                            <td class="px-6 py-4 text-sm">{{ $order->created_at->format('d/m/Y H:i') }}</td>
                            <td class="px-6 py-4 text-sm font-medium">{{ number_format($order->total_amount, 0, ',', ' ') }} {{ config('shop.currency_symbol') }}</td>
                            <td class="px-6 py-4">
                                <span class="px-2 py-1 text-xs rounded-full
                                    @if($order->status === 'EN_ATTENTE_TRAITEMENT') bg-amber-100 text-amber-700
                                    @elseif($order->status === 'EN_ATTENTE_LIVRAISON') bg-blue-100 text-blue-700
                                    @elseif($order->status === 'LIVREE') bg-green-100 text-green-700
                                    @else bg-gray-100 text-gray-700
                                    @endif">
                                    @switch($order->status)
                                        @case('EN_ATTENTE_TRAITEMENT') En attente @break
                                        @case('EN_ATTENTE_LIVRAISON') En livraison @break
                                        @case('LIVREE') Livrée @break
                                        @case('ANNULEE') Annulée @break
                                    @endswitch
                                </span>
                            </td>
                            <td class="px-6 py-4">
                                <a href="{{ route('admin.orders.show', $order->id) }}"
                                   class="text-primary hover:text-blue-900">
                                    <i data-lucide="eye" class="h-4 w-4"></i>
                                </a>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="p-4 border-t">
                {{ $orders->links() }}
            </div>
        @endif
    </div>
</div>
@endsection
