@extends('layouts.admin')

@section('title', 'Catégories')
@section('page-title', 'Catégories')

@section('content')
<div class="bg-white rounded-lg shadow-sm p-6">
    <div class="flex items-center justify-between mb-6">
        <h2 class="text-lg font-semibold">Liste des catégories</h2>
        <a href="{{ route('admin.categories.create') }}"
           class="inline-flex items-center gap-2 px-4 py-2 rounded-lg bg-primary text-white text-sm hover:bg-primary/90">
            <i data-lucide="plus" class="h-4 w-4"></i>
            Nouvelle catégorie
        </a>
    </div>

    <!-- Filters -->
    <form action="{{ route('admin.categories.index') }}" method="GET" class="flex flex-wrap gap-3 mb-6">
        <input type="text" name="search" value="{{ $currentFilters['search'] ?? '' }}"
               placeholder="Rechercher par nom..."
               class="px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-primary focus:border-transparent">
        <select name="active" class="px-3 py-2 border border-gray-300 rounded-lg text-sm">
            <option value="">Tous les statuts</option>
            <option value="true" {{ ($currentFilters['active'] ?? '') === 'true' ? 'selected' : '' }}>Actif</option>
            <option value="false" {{ ($currentFilters['active'] ?? '') === 'false' ? 'selected' : '' }}>Inactif</option>
        </select>
        <button type="submit" class="px-4 py-2 bg-gray-100 text-gray-700 rounded-lg text-sm hover:bg-gray-200">Filtrer</button>
        @if(array_filter($currentFilters))
            <a href="{{ route('admin.categories.index') }}" class="px-4 py-2 text-gray-500 text-sm hover:text-gray-700">Réinitialiser</a>
        @endif
    </form>

    @if($categories->isEmpty())
        <p class="text-sm text-gray-600">Aucune catégorie trouvée.</p>
    @else
        <div class="overflow-x-auto">
            <table class="min-w-full text-sm">
                <thead>
                    <tr class="text-left border-b bg-gray-50">
                        <th class="px-4 py-3 font-medium text-gray-600">Ordre</th>
                        <th class="px-4 py-3 font-medium text-gray-600">Nom</th>
                        <th class="px-4 py-3 font-medium text-gray-600">Slug</th>
                        <th class="px-4 py-3 font-medium text-gray-600">Produits</th>
                        <th class="px-4 py-3 font-medium text-gray-600">Statut</th>
                        <th class="px-4 py-3 font-medium text-gray-600">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y">
                    @foreach($categories as $category)
                    <tr class="hover:bg-gray-50">
                        <td class="px-4 py-3 text-gray-500">{{ $category->order }}</td>
                        <td class="px-4 py-3 font-medium">{{ $category->name }}</td>
                        <td class="px-4 py-3 text-gray-500 font-mono text-xs">{{ $category->slug }}</td>
                        <td class="px-4 py-3">
                            <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-700">
                                {{ $category->products_count }}
                            </span>
                        </td>
                        <td class="px-4 py-3">
                            <form action="{{ route('admin.categories.toggle', $category->id) }}" method="POST" class="inline">
                                @csrf
                                <button type="submit"
                                        class="px-2 py-1 text-xs rounded-full {{ $category->is_active ? 'bg-green-100 text-green-700' : 'bg-gray-100 text-gray-600' }}">
                                    {{ $category->is_active ? 'Actif' : 'Inactif' }}
                                </button>
                            </form>
                        </td>
                        <td class="px-4 py-3">
                            <div class="flex items-center gap-3">
                                <a href="{{ route('admin.categories.edit', $category->id) }}"
                                   class="text-primary hover:underline text-sm">Modifier</a>
                                @if($category->products_count === 0)
                                <form action="{{ route('admin.categories.destroy', $category->id) }}" method="POST"
                                      onsubmit="return confirm('Supprimer cette catégorie ?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="text-red-600 hover:underline text-sm">Supprimer</button>
                                </form>
                                @endif
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div class="mt-4">
            {{ $categories->links() }}
        </div>
    @endif
</div>
@endsection
