@extends('layouts.app')

@section('title', 'À propos de Jolis Matelas')

@push('styles')
<style>
    .about-page .page-header {
        padding-top: 3.5rem;
        padding-bottom: 3.5rem;
        background: linear-gradient(120deg, #f8fafc 0%, #eff6ff 52%, #f8fafc 100%);
        border-bottom: 1px solid #e5e7eb;
    }
    .about-page .page-header h1 {
        color: #003D82;
        text-align: center;
    }
    .about-page .page-header p {
        color: #475569;
        text-align: center;
    }
    .about-page .page-header nav {
        display: flex;
        justify-content: center;
        margin-bottom: 0.75rem;
    }
    .about-page .page-header nav a {
        color: #64748b;
    }
    .about-page .page-header nav span {
        color: #94a3b8;
    }
    .about-page .page-header nav a:hover {
        color: #003D82;
    }
    .about-page .cta-panel {
        background: linear-gradient(120deg, #f8fafc 0%, #eff6ff 100%);
        border: 1px solid #e5e7eb;
    }
</style>
@endpush

@section('content')
<div class="min-h-screen bg-gray-50 about-page">
    @include('partials.page-hero', [
        'title' => 'À propos de Jolis Matelas',
        'subtitle' => 'Découvrez notre histoire et nos engagements',
        'breadcrumbs' => [
            ['label' => 'Accueil', 'href' => route('home')],
            ['label' => 'À propos']
        ]
    ])

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12 space-y-16">
        <section class="grid grid-cols-1 lg:grid-cols-2 gap-10 lg:gap-12 items-center">
            <div class="order-1 lg:order-2">
                <div class="aspect-[4/3] rounded-2xl overflow-hidden border border-gray-100 shadow-sm bg-white">
                    <img src="{{ asset('images/placeholder.jpg') }}" alt="Notre mission" class="h-full w-full object-cover">
                </div>
            </div>
            <div class="order-2 lg:order-1 space-y-4">
                <h2 class="text-2xl font-semibold text-primary font-display section-title">Notre mission</h2>
                <p class="text-gray-600 leading-relaxed body-text">
                    Offrir à chaque client un sommeil réparateur grâce à des matelas sélectionnés avec soin et un accompagnement humain.
                </p>
                <p class="text-gray-600 leading-relaxed body-text">
                    Nous privilégions la qualité, la transparence et le conseil pour vous aider à choisir la literie qui vous convient.
                </p>
            </div>
        </section>

        <section class="grid grid-cols-1 lg:grid-cols-2 gap-10 lg:gap-12 items-center">
            <div class="order-1">
                <div class="aspect-[4/3] rounded-2xl overflow-hidden border border-gray-100 shadow-sm bg-white">
                    <img src="{{ asset('images/placeholder.jpg') }}" alt="Notre vision" class="h-full w-full object-cover">
                </div>
            </div>
            <div class="order-2 space-y-4">
                <h2 class="text-2xl font-semibold text-primary font-display section-title">Vision & Objectifs</h2>
                <p class="text-gray-600 leading-relaxed body-text">
                    Devenir la référence locale du confort de la maison au Cameroun en combinant qualité, prix justes et service de proximité.
                </p>
                <p class="text-gray-600 leading-relaxed body-text">
                    Notre ambition est de créer une expérience simple, rassurante et premium à chaque étape, du conseil à la livraison.
                </p>
            </div>
        </section>

        <section class="bg-white rounded-2xl shadow-sm p-8 border border-gray-100">
            <h2 class="text-2xl font-semibold text-primary mb-6 font-display text-center section-title">Nos valeurs</h2>
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
                <div class="card h-full flex flex-col items-center text-center gap-3 p-5">
                    <div class="h-12 w-12 rounded-full bg-primary/10 flex items-center justify-center">
                        <i data-lucide="shield-check" class="h-6 w-6 text-primary"></i>
                    </div>
                    <h3 class="font-semibold text-gray-900">Qualité premium</h3>
                    <p class="text-sm text-gray-500 line-clamp-2 body-text">Des matériaux fiables pour un confort durable</p>
                </div>
                <div class="card h-full flex flex-col items-center text-center gap-3 p-5">
                    <div class="h-12 w-12 rounded-full bg-accent/10 flex items-center justify-center">
                        <i data-lucide="handshake" class="h-6 w-6 text-accent"></i>
                    </div>
                    <h3 class="font-semibold text-gray-900">Confiance</h3>
                    <p class="text-sm text-gray-500 line-clamp-2 body-text">Transparence totale sur nos produits et services</p>
                </div>
                <div class="card h-full flex flex-col items-center text-center gap-3 p-5">
                    <div class="h-12 w-12 rounded-full bg-primary/10 flex items-center justify-center">
                        <i data-lucide="heart" class="h-6 w-6 text-primary"></i>
                    </div>
                    <h3 class="font-semibold text-gray-900">Service attentif</h3>
                    <p class="text-sm text-gray-500 line-clamp-2 body-text">Un accompagnement humain avant et après l’achat</p>
                </div>
                <div class="card h-full flex flex-col items-center text-center gap-3 p-5">
                    <div class="h-12 w-12 rounded-full bg-accent/10 flex items-center justify-center">
                        <i data-lucide="map-pin" class="h-6 w-6 text-accent"></i>
                    </div>
                    <h3 class="font-semibold text-gray-900">Engagement local</h3>
                    <p class="text-sm text-gray-500 line-clamp-2 body-text">Une présence proche de vous et de vos besoins</p>
                </div>
            </div>
        </section>

        <section class="bg-white rounded-2xl shadow-sm p-8 border border-gray-100">
            <h2 class="text-2xl font-semibold text-primary mb-6 font-display text-center section-title">Ce qui fait la différence</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-5">
                <div class="card h-full p-5 rounded-2xl bg-gray-50 border border-gray-100">
                    <div class="h-10 w-10 rounded-full bg-primary/10 flex items-center justify-center mb-4">
                        <i data-lucide="sparkles" class="h-5 w-5 text-primary"></i>
                    </div>
                    <h3 class="font-semibold text-gray-900 mb-2">Qualité sélectionnée</h3>
                    <p class="text-sm text-gray-500 line-clamp-3 body-text">Des collections testées pour un confort optimal</p>
                </div>
                <div class="card h-full p-5 rounded-2xl bg-gray-50 border border-gray-100">
                    <div class="h-10 w-10 rounded-full bg-accent/10 flex items-center justify-center mb-4">
                        <i data-lucide="truck" class="h-5 w-5 text-accent"></i>
                    </div>
                    <h3 class="font-semibold text-gray-900 mb-2">Livraison fluide</h3>
                    <p class="text-sm text-gray-500 line-clamp-3 body-text">Livraison gratuite et prise en main facile</p>
                </div>
                <div class="card h-full p-5 rounded-2xl bg-gray-50 border border-gray-100">
                    <div class="h-10 w-10 rounded-full bg-primary/10 flex items-center justify-center mb-4">
                        <i data-lucide="headphones" class="h-5 w-5 text-primary"></i>
                    </div>
                    <h3 class="font-semibold text-gray-900 mb-2">SAV réactif</h3>
                    <p class="text-sm text-gray-500 line-clamp-3 body-text">Une équipe disponible pour vous accompagner</p>
                </div>
                <div class="card h-full p-5 rounded-2xl bg-gray-50 border border-gray-100">
                    <div class="h-10 w-10 rounded-full bg-accent/10 flex items-center justify-center mb-4">
                        <i data-lucide="gift" class="h-5 w-5 text-accent"></i>
                    </div>
                    <h3 class="font-semibold text-gray-900 mb-2">Oreiller offert</h3>
                    <p class="text-sm text-gray-500 line-clamp-3 body-text">Un oreiller offert pour chaque matelas acheté</p>
                </div>
            </div>
        </section>

        <div class="pt-6">
            <div class="cta-panel rounded-2xl px-6 py-10 text-center">
                <h2 class="text-2xl font-bold text-primary mb-3 font-display section-title">Découvrir nos produits</h2>
                <p class="text-gray-600 mb-6 body-text">Explorez notre sélection de matelas et d’accessoires.</p>
                <a href="{{ route('products.index') }}" class="btn btn-default btn-lg">
                    Découvrir nos produits
                </a>
            </div>
        </div>
    </div>
</div>
@endsection
