<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    public function run(): void
    {
        // Admin user
        User::create([
            'first_name' => 'Admin',
            'last_name' => 'JOLI',
            'email' => 'admin@joli-matelas.fr',
            'password' => Hash::make('password'),
            'phone' => '0123456789',
            'role' => 'ADMIN',
        ]);

        // Customer user (optionnel)
        User::create([
            'first_name' => 'Jean',
            'last_name' => 'Dupont',
            'email' => 'jean.dupont@example.com',
            'password' => Hash::make('password'),
            'phone' => '0601020304',
            'role' => 'CUSTOMER',
        ]);

        $this->command->info('✓ Users created: 1 admin, 1 customer');
    }
}
