<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Store;

class StoreSeeder extends Seeder
{
    public function run(): void
    {
        $stores = [
            [
                'name' => 'JOLI Matelas Paris Centre',
                'phone' => '0144556677',
                'email' => 'paris@joli-matelas.fr',
                'street' => '25 Avenue des Champs-Élysées',
                'city' => 'Paris',
                'postal_code' => '75008',
                'country' => 'France',
                'latitude' => 48.8698,
                'longitude' => 2.3078,
                'is_active' => true,
            ],
            [
                'name' => 'JOLI Matelas Lyon',
                'phone' => '0478889900',
                'email' => 'lyon@joli-matelas.fr',
                'street' => '15 Rue de la République',
                'city' => 'Lyon',
                'postal_code' => '69002',
                'country' => 'France',
                'latitude' => 45.7640,
                'longitude' => 4.8357,
                'is_active' => true,
            ],
            [
                'name' => 'JOLI Matelas Marseille',
                'phone' => '0491223344',
                'email' => 'marseille@joli-matelas.fr',
                'street' => '50 La Canebière',
                'city' => 'Marseille',
                'postal_code' => '13001',
                'country' => 'France',
                'latitude' => 43.2965,
                'longitude' => 5.3698,
                'is_active' => true,
            ],
            [
                'name' => 'JOLI Matelas Bordeaux',
                'phone' => '0556778899',
                'email' => 'bordeaux@joli-matelas.fr',
                'street' => '30 Cours de l\'Intendance',
                'city' => 'Bordeaux',
                'postal_code' => '33000',
                'country' => 'France',
                'latitude' => 44.8378,
                'longitude' => -0.5792,
                'is_active' => true,
            ],
            [
                'name' => 'JOLI Matelas Toulouse',
                'phone' => '0561223344',
                'email' => 'toulouse@joli-matelas.fr',
                'street' => '12 Rue Saint-Rome',
                'city' => 'Toulouse',
                'postal_code' => '31000',
                'country' => 'France',
                'latitude' => 43.6047,
                'longitude' => 1.4442,
                'is_active' => true,
            ],
        ];

        foreach ($stores as $store) {
            Store::create($store);
        }

        $this->command->info('✓ Stores created: ' . count($stores));
    }
}
