<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Setting;

class SettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $settings = [
            // Email Configuration
            [
                'key' => 'mail_from_address',
                'value' => 'contact@joli-matelas.fr',
                'type' => 'string',
                'description' => 'Adresse email expéditeur pour les emails système',
            ],
            [
                'key' => 'mail_from_name',
                'value' => 'JOLI Matelas',
                'type' => 'string',
                'description' => 'Nom expéditeur pour les emails système',
            ],
            [
                'key' => 'admin_notification_emails',
                'value' => json_encode(['admin@joli-matelas.fr']),
                'type' => 'json',
                'description' => 'Liste des emails administrateurs pour les notifications',
            ],

            // Stock Configuration
            [
                'key' => 'stock_alert_threshold',
                'value' => '5',
                'type' => 'integer',
                'description' => 'Seuil critique du stock (quantité minimale avant alerte)',
            ],
            [
                'key' => 'stock_alert_enabled',
                'value' => '1',
                'type' => 'boolean',
                'description' => 'Activer les alertes de stock critique',
            ],

            // Store Information
            [
                'key' => 'company_name',
                'value' => 'JOLI Matelas',
                'type' => 'string',
                'description' => 'Nom de l\'entreprise',
            ],
            [
                'key' => 'company_phone',
                'value' => '01 23 45 67 89',
                'type' => 'string',
                'description' => 'Téléphone principal de l\'entreprise',
            ],
            [
                'key' => 'company_email',
                'value' => 'contact@joli-matelas.fr',
                'type' => 'string',
                'description' => 'Email de contact principal',
            ],
            [
                'key' => 'company_address',
                'value' => '123 Avenue des Matelas, 75001 Paris, France',
                'type' => 'string',
                'description' => 'Adresse du siège social',
            ],

            // Order Configuration
            [
                'key' => 'order_notification_enabled',
                'value' => '1',
                'type' => 'boolean',
                'description' => 'Activer les notifications email pour les nouvelles commandes',
            ],
        ];

        foreach ($settings as $setting) {
            Setting::updateOrCreate(
                ['key' => $setting['key']],
                [
                    'value' => $setting['value'],
                    'type' => $setting['type'],
                    'description' => $setting['description'],
                ]
            );
        }

        $this->command->info('Settings seeded successfully!');
    }
}
