<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Product;
use App\Models\ProductVariant;
use App\Models\Category;
use App\Models\Store;
use App\Models\StockItem;

class ProductSeeder extends Seeder
{
    public function run(): void
    {
        $categories = Category::all();
        $stores = Store::all();

        if ($categories->isEmpty() || $stores->isEmpty()) {
            $this->command->error('Please run CategorySeeder and StoreSeeder first!');
            return;
        }

        $products = [
            [
                'name' => 'Matelas Mousse Confort Plus',
                'slug' => 'matelas-mousse-confort-plus',
                'description' => 'Matelas en mousse haute densité pour un confort optimal. Parfait pour toutes les positions de sommeil.',
                'base_price' => 299.00,
                'type' => 'FOAM',
                'category_id' => $categories->where('slug', 'matelas-confort')->first()->id,
                'images' => json_encode([
                    'https://res.cloudinary.com/demo/image/upload/v1/samples/products/mattress-1.jpg',
                ]),
            ],
            [
                'name' => 'Matelas Ressorts Ensachés Premium',
                'slug' => 'matelas-ressorts-ensaches-premium',
                'description' => 'Technologie ressorts ensachés pour une indépendance de couchage parfaite. Soutien ferme et durable.',
                'base_price' => 499.00,
                'type' => 'SPRING',
                'category_id' => $categories->where('slug', 'matelas-premium')->first()->id,
                'images' => json_encode([
                    'https://res.cloudinary.com/demo/image/upload/v1/samples/products/mattress-2.jpg',
                ]),
            ],
            [
                'name' => 'Matelas Latex Naturel Bio',
                'slug' => 'matelas-latex-naturel-bio',
                'description' => 'Matelas en latex 100% naturel, hypoallergénique et respirant. Idéal pour les personnes sensibles.',
                'base_price' => 699.00,
                'type' => 'LATEX',
                'category_id' => $categories->where('slug', 'matelas-premium')->first()->id,
                'images' => json_encode([
                    'https://res.cloudinary.com/demo/image/upload/v1/samples/products/mattress-3.jpg',
                ]),
            ],
            [
                'name' => 'Matelas Hybride Ergonomique',
                'slug' => 'matelas-hybride-ergonomique',
                'description' => 'Combinaison de mousse à mémoire de forme et ressorts pour un soutien optimal. Le meilleur des deux technologies.',
                'base_price' => 599.00,
                'type' => 'HYBRID',
                'category_id' => $categories->where('slug', 'matelas-orthopediques')->first()->id,
                'images' => json_encode([
                    'https://res.cloudinary.com/demo/image/upload/v1/samples/products/mattress-4.jpg',
                ]),
            ],
            [
                'name' => 'Matelas Mousse Mémoire Deluxe',
                'slug' => 'matelas-mousse-memoire-deluxe',
                'description' => 'Mousse à mémoire de forme premium qui épouse parfaitement votre corps. Soulage les points de pression.',
                'base_price' => 449.00,
                'type' => 'FOAM',
                'category_id' => $categories->where('slug', 'matelas-premium')->first()->id,
                'images' => json_encode([
                    'https://res.cloudinary.com/demo/image/upload/v1/samples/products/mattress-5.jpg',
                ]),
            ],
            [
                'name' => 'Matelas Ressorts Classique',
                'slug' => 'matelas-ressorts-classique',
                'description' => 'Matelas à ressorts traditionnel offrant un excellent rapport qualité-prix. Soutien ferme et aéré.',
                'base_price' => 349.00,
                'type' => 'SPRING',
                'category_id' => $categories->where('slug', 'matelas-confort')->first()->id,
                'images' => json_encode([
                    'https://res.cloudinary.com/demo/image/upload/v1/samples/products/mattress-6.jpg',
                ]),
            ],
            [
                'name' => 'Matelas Orthopédique Pro',
                'slug' => 'matelas-orthopedique-pro',
                'description' => 'Matelas orthopédique recommandé par les professionnels de santé. Soutien lombaire renforcé.',
                'base_price' => 799.00,
                'type' => 'HYBRID',
                'category_id' => $categories->where('slug', 'matelas-orthopediques')->first()->id,
                'images' => json_encode([
                    'https://res.cloudinary.com/demo/image/upload/v1/samples/products/mattress-7.jpg',
                ]),
            ],
            [
                'name' => 'Matelas Latex Souple',
                'slug' => 'matelas-latex-souple',
                'description' => 'Latex naturel avec accueil moelleux. Parfait pour ceux qui préfèrent un confort enveloppant.',
                'base_price' => 549.00,
                'type' => 'LATEX',
                'category_id' => $categories->where('slug', 'matelas-confort')->first()->id,
                'images' => json_encode([
                    'https://res.cloudinary.com/demo/image/upload/v1/samples/products/mattress-8.jpg',
                ]),
            ],
        ];

        // Tailles disponibles pour les variantes
        $sizes = [
            ['size' => '90x190', 'price_modifier' => 0],
            ['size' => '140x190', 'price_modifier' => 100],
            ['size' => '160x200', 'price_modifier' => 150],
            ['size' => '180x200', 'price_modifier' => 200],
        ];

        foreach ($products as $productData) {
            // Créer le produit
            $product = Product::create($productData);

            // Créer les variantes
            foreach ($sizes as $size) {
                $variant = ProductVariant::create([
                    'product_id' => $product->id,
                    'size' => $size['size'],
                    'price' => $product->base_price + $size['price_modifier'],
                ]);

                // Créer le stock pour chaque magasin
                foreach ($stores as $store) {
                    // Stock aléatoire entre 5 et 20 unités
                    $quantity = rand(5, 20);

                    StockItem::create([
                        'product_id' => $product->id,
                        'variant_id' => $variant->id,
                        'store_id' => $store->id,
                        'quantity' => $quantity,
                        'reserved_quantity' => 0,
                    ]);
                }
            }

            $this->command->info("✓ Product created: {$product->name} with " . count($sizes) . " variants");
        }

        $this->command->info('✓ Total products created: ' . count($products));
        $this->command->info('✓ Total variants created: ' . (count($products) * count($sizes)));
        $this->command->info('✓ Total stock items created: ' . (count($products) * count($sizes) * count($stores)));
    }
}
