<?php

namespace Database\Seeders;

use App\Models\FulfillmentSource;
use App\Models\Store;
use Illuminate\Database\Seeder;

class FulfillmentSourceSeeder extends Seeder
{
    public function run(): void
    {
        // Sources fixes
        FulfillmentSource::firstOrCreate(
            ['name' => 'Dépôt central', 'type' => 'WAREHOUSE'],
            ['is_active' => true]
        );

        FulfillmentSource::firstOrCreate(
            ['name' => 'Usine', 'type' => 'FACTORY'],
            ['is_active' => true]
        );

        // Créer une source pour chaque magasin actif
        $stores = Store::where('is_active', true)->get();
        foreach ($stores as $store) {
            FulfillmentSource::firstOrCreate(
                ['name' => "Magasin {$store->name}", 'type' => 'STORE'],
                ['is_active' => true, 'notes' => "Lié au magasin #{$store->id} - {$store->city}"]
            );
        }

        $this->command->info('✓ Sources de prélèvement créées');
    }
}
