<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Category;

class CategorySeeder extends Seeder
{
    public function run(): void
    {
        $categories = [
            [
                'name' => 'Matelas Premium',
                'slug' => 'matelas-premium',
                'description' => 'Notre sélection de matelas haut de gamme pour un confort optimal',
            ],
            [
                'name' => 'Matelas Confort',
                'slug' => 'matelas-confort',
                'description' => 'Matelas confortables à prix abordable',
            ],
            [
                'name' => 'Matelas Orthopédiques',
                'slug' => 'matelas-orthopediques',
                'description' => 'Matelas spécialement conçus pour le soutien du dos',
            ],
        ];

        foreach ($categories as $category) {
            Category::create($category);
        }

        $this->command->info('✓ Categories created: ' . count($categories));
    }
}
