<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Cette migration documente l'ajout de reserved_quantity au modèle StockItem.
     * La colonne existe déjà en base (créée par 2024_01_01_000006_create_stock_items_table.php).
     * Cette migration sert de documentation et initialise reserved_quantity à 0.
     */
    public function up(): void
    {
        // S'assurer que reserved_quantity = 0 pour tous les stocks existants
        DB::table('stock_items')->update(['reserved_quantity' => 0]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Pas de rollback nécessaire
    }
};
