<?php

namespace App\Services;

use App\Models\Setting;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Schema;

class MailSettingsService
{
    public static function apply(): void
    {
        if (!Schema::hasTable('settings')) {
            return;
        }

        try {
            $enabled = (bool) Setting::get('mail_enabled', false);

            if (!$enabled) {
                config(['mail.default' => 'array']);
                return;
            }

            $mailer = Setting::get('mail_mailer', 'smtp') ?: 'smtp';
            $host = Setting::get('mail_host');
            $port = Setting::get('mail_port');
            $username = Setting::get('mail_username');
            $password = Setting::get('mail_password');
            $encryption = Setting::get('mail_encryption');
            $fromAddress = Setting::get('mail_from_address');
            $fromName = Setting::get('mail_from_name', config('app.name'));
            $replyToAddress = Setting::get('mail_reply_to_address');
            $replyToName = Setting::get('mail_reply_to_name');

            if ($encryption === 'none' || $encryption === '') {
                $encryption = null;
            }

            config([
                'mail.default' => $mailer,
                'mail.mailers.smtp.host' => $host,
                'mail.mailers.smtp.port' => $port,
                'mail.mailers.smtp.encryption' => $encryption,
                'mail.mailers.smtp.username' => $username,
                'mail.mailers.smtp.password' => $password !== '' ? $password : null,
                'mail.from.address' => $fromAddress,
                'mail.from.name' => $fromName ?: config('app.name'),
            ]);

            if ($replyToAddress) {
                Mail::alwaysReplyTo($replyToAddress, $replyToName ?: null);
            }
        } catch (\Throwable $e) {
            Log::warning('Failed to apply mail settings', [
                'error' => $e->getMessage(),
            ]);
        }
    }
}
