<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StockInventoryLine extends Model
{
    use HasFactory;

    protected $fillable = [
        'stock_inventory_id',
        'product_id',
        'variant_id',
        'theoretical_qty',
        'real_qty',
        'gap',
    ];

    protected $casts = [
        'theoretical_qty' => 'integer',
        'real_qty' => 'integer',
        'gap' => 'integer',
    ];

    public function inventory()
    {
        return $this->belongsTo(StockInventory::class, 'stock_inventory_id');
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function variant()
    {
        return $this->belongsTo(ProductVariant::class, 'variant_id');
    }
}
