<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class FulfillmentSource extends Model
{
    protected $fillable = [
        'name',
        'type',
        'is_active',
        'notes',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    public function orders()
    {
        return $this->hasMany(Order::class);
    }

    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }
}
