<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class StoreResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'description' => $this->description,

            // Adresse
            'address' => [
                'street' => $this->street,
                'city' => $this->city,
                'postal_code' => $this->postal_code,
                'country' => $this->country,
                'full_address' => $this->full_address,
            ],

            // Contact
            'phone' => $this->phone,
            'email' => $this->email,

            // Coordonnées GPS
            'location' => [
                'latitude' => $this->latitude ? (float) $this->latitude : null,
                'longitude' => $this->longitude ? (float) $this->longitude : null,
            ],

            // Horaires
            'opening_hours' => $this->opening_hours,

            // Statut
            'is_active' => (bool) $this->is_active,

            // Stock (si chargé)
            'stock_items' => $this->when(
                $this->relationLoaded('stockItems'),
                StockItemResource::collection($this->stockItems)
            ),

            // Nombre total de produits en stock
            'total_products' => $this->when(
                $this->relationLoaded('stockItems'),
                $this->stockItems->count()
            ),

            // Valeur totale du stock
            'total_stock_value' => $this->when(
                $this->relationLoaded('stockItems'),
                $this->total_stock_value
            ),

            // Dates
            'created_at' => $this->created_at?->toIso8601String(),
            'updated_at' => $this->updated_at?->toIso8601String(),
        ];
    }
}
