<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class StockItemResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'quantity' => $this->quantity,
            'alert_threshold' => $this->alert_threshold,
            'is_low_stock' => $this->isLowStock(),
            'is_out_of_stock' => $this->isOutOfStock(),

            // Produit (si chargé)
            'product' => $this->when($this->relationLoaded('product'), function () {
                return [
                    'id' => $this->product->id,
                    'name' => $this->product->name,
                    'slug' => $this->product->slug,
                ];
            }),

            // Variante (si chargé)
            'variant' => $this->when($this->relationLoaded('variant'), function () {
                return [
                    'id' => $this->variant->id,
                    'size' => $this->variant->size,
                    'price' => (float) $this->variant->price,
                    'sku' => $this->variant->sku,
                ];
            }),

            // Magasin (si chargé)
            'store' => $this->when($this->relationLoaded('store'), function () {
                return [
                    'id' => $this->store->id,
                    'name' => $this->store->name,
                    'city' => $this->store->city,
                ];
            }),

            // Dates
            'created_at' => $this->created_at?->toIso8601String(),
            'updated_at' => $this->updated_at?->toIso8601String(),
        ];
    }
}
