<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProductVariantResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'size' => $this->size,
            'price' => (float) $this->price,
            'sku' => $this->sku,
            'is_active' => (bool) $this->is_active,

            // Stock par magasin (si chargé)
            'stock_items' => $this->when(
                $this->relationLoaded('stockItems'),
                StockItemResource::collection($this->stockItems)
            ),

            // Stock total disponible (quantity - reserved_quantity)
            'total_stock' => $this->when(
                $this->relationLoaded('stockItems'),
                function () {
                    return $this->stockItems->sum(function ($item) {
                        return $item->quantity - $item->reserved_quantity;
                    });
                }
            ),

            // Disponibilité de la variante
            'is_available' => $this->when(
                $this->relationLoaded('stockItems'),
                function () {
                    $available = $this->stockItems->sum(function ($item) {
                        return $item->quantity - $item->reserved_quantity;
                    });
                    return $available > 0;
                }
            ),

            // Dates
            'created_at' => $this->created_at?->toIso8601String(),
            'updated_at' => $this->updated_at?->toIso8601String(),
        ];
    }
}
