<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OrderStatusHistoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'old_status' => $this->old_status,
            'new_status' => $this->new_status,
            'comment' => $this->comment,

            // Utilisateur qui a effectué le changement
            'changed_by' => $this->when($this->relationLoaded('changedBy'), function () {
                return $this->changedBy ? [
                    'id' => $this->changedBy->id,
                    'name' => $this->changedBy->full_name,
                ] : null;
            }),

            'created_at' => $this->created_at?->toIso8601String(),
        ];
    }
}
