<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OrderItemResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'product_name' => $this->product_name,
            'variant_size' => $this->variant_size,
            'unit_price' => (float) $this->unit_price,
            'quantity' => $this->quantity,
            'subtotal' => (float) $this->subtotal,

            // Produit actuel (si existe encore)
            'product' => $this->when($this->relationLoaded('product'), function () {
                return [
                    'id' => $this->product->id,
                    'name' => $this->product->name,
                    'slug' => $this->product->slug,
                    'thumbnail' => $this->product->thumbnail,
                ];
            }),

            // Variante actuelle (si existe encore)
            'variant' => $this->when($this->relationLoaded('variant'), function () {
                return [
                    'id' => $this->variant->id,
                    'size' => $this->variant->size,
                    'sku' => $this->variant->sku,
                ];
            }),

            'created_at' => $this->created_at?->toIso8601String(),
        ];
    }
}
