<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CreateStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'name' => 'required|string|max:255',
            'description' => 'nullable|string|max:1000',
            'street' => 'required|string|max:500',
            'city' => 'required|string|max:255',
            'postal_code' => 'required|string|max:20',
            'country' => 'nullable|string|max:100',
            'phone' => 'required|string|max:20|regex:/^[0-9+\s\-()]+$/',
            'email' => 'required|email|max:255',
            'latitude' => 'nullable|numeric|between:-90,90',
            'longitude' => 'nullable|numeric|between:-180,180',
            'opening_hours' => 'nullable|array',
            'is_active' => 'nullable|boolean',
        ];
    }

    /**
     * Get custom messages for validator errors.
     *
     * @return array
     */
    public function messages(): array
    {
        return [
            'name.required' => 'Le nom du magasin est obligatoire',
            'street.required' => 'L\'adresse est obligatoire',
            'city.required' => 'La ville est obligatoire',
            'postal_code.required' => 'Le code postal est obligatoire',
            'phone.required' => 'Le téléphone est obligatoire',
            'phone.regex' => 'Le format du numéro de téléphone est invalide',
            'email.required' => 'L\'email est obligatoire',
            'email.email' => 'L\'adresse email est invalide',
            'latitude.between' => 'La latitude doit être entre -90 et 90',
            'longitude.between' => 'La longitude doit être entre -180 et 180',
        ];
    }
}
