<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EnsureUserIsAdmin
{
    /**
     * Handle an incoming request.
     *
     * Vérifie que l'utilisateur est authentifié, actif, et a le rôle ADMIN
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Vérifier authentification
        if (!auth()->check()) {
            if ($request->expectsJson()) {
                return response()->json(['message' => 'Unauthenticated'], 401);
            }
            return redirect()->route('admin.login');
        }

        $user = auth()->user();

        // Vérifier rôle ADMIN
        if ($user->role !== 'ADMIN') {
            auth()->logout();
            if ($request->expectsJson()) {
                return response()->json(['message' => 'Forbidden - Admin access required'], 403);
            }
            return redirect()->route('admin.login')
                ->with('error', 'Accès refusé. Vous n\'êtes pas administrateur.');
        }

        // Vérifier compte actif
        if (!$user->is_active) {
            auth()->logout();
            if ($request->expectsJson()) {
                return response()->json(['message' => 'Account disabled'], 403);
            }
            return redirect()->route('admin.login')
                ->with('error', 'Votre compte est désactivé.');
        }

        return $next($request);
    }
}
