<?php

namespace App\Http\Controllers;

use App\Models\Store;
use Illuminate\View\View;

class StoreController extends Controller
{
    /**
     * Display stores listing
     */
    public function index(): View
    {
        $stores = Store::active()
            ->orderBy('name')
            ->get();

        return view('stores.index', [
            'stores' => $stores,
        ]);
    }

    /**
     * Display single store
     */
    public function show(int $id): View
    {
        $store = Store::active()
            ->findOrFail($id);

        return view('stores.show', [
            'store' => $store,
        ]);
    }
}
