<?php

namespace App\Http\Controllers;

use App\Models\Promotion;
use Illuminate\View\View;

class PromotionController extends Controller
{
    /**
     * Display active promotions
     */
    public function index(): View
    {
        $promotions = Promotion::active()
            ->orderBy('end_date')
            ->get();

        return view('promotions.index', [
            'promotions' => $promotions,
        ]);
    }
}
