<?php

namespace App\Http\Controllers;

use App\Models\Product;
use App\Models\Promotion;
use Illuminate\View\View;

class HomeController extends Controller
{
    /**
     * Display the homepage
     */
    public function index(): View
    {
        $products = Product::with(['variants', 'category'])
            ->active()
            ->featured()
            ->take(6)
            ->get();
        $featuredFallback = false;

        if ($products->isEmpty()) {
            $products = Product::with(['variants', 'category'])
                ->active()
                ->orderBy('created_at', 'desc')
                ->take(6)
                ->get();
            $featuredFallback = true;
        }

        $promotions = Promotion::active()
            ->orderBy('end_date')
            ->take(3)
            ->get();

        return view('home', [
            'products' => $products,
            'promotions' => $promotions,
            'featuredFallback' => $featuredFallback,
        ]);
    }
}
