<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Product;
use App\Models\Store;
use App\Models\Order;
use App\Models\StockItem;
use Illuminate\Support\Facades\DB;
use Illuminate\View\View;

class DashboardController extends Controller
{
    public function index(): View
    {
        // Products statistics
        $productsStats = [
            'total' => Product::count(),
            'active' => Product::where('is_active', true)->count(),
        ];

        // Stores statistics
        $storesStats = [
            'total' => Store::count(),
            'active' => Store::where('is_active', true)->count(),
        ];

        // Orders statistics
        $ordersStats = [
            'total' => Order::count(),
            'pending' => Order::where('status', 'EN_ATTENTE_TRAITEMENT')->count(),
            'shipping' => Order::where('status', 'EN_ATTENTE_LIVRAISON')->count(),
            'delivered' => Order::where('status', 'LIVREE')->count(),
            'cancelled' => Order::where('status', 'ANNULEE')->count(),
            'revenue' => Order::where('status', 'LIVREE')->sum('total_amount'),
        ];

        // Stock statistics
        $stockStats = [
            'total_items' => StockItem::count(),
            'total_quantity' => StockItem::sum('quantity'),
            'total_reserved' => StockItem::sum('reserved_quantity'),
            'low_stock_count' => StockItem::whereColumn('quantity', '<=', 'alert_threshold')->count(),
        ];

        // Low stock alerts
        $lowStockAlerts = StockItem::whereColumn('quantity', '<=', 'alert_threshold')
            ->with(['product', 'variant', 'store'])
            ->orderBy('quantity', 'asc')
            ->limit(10)
            ->get();

        // Recent orders
        $recentOrders = Order::with(['store'])
            ->orderBy('created_at', 'desc')
            ->limit(10)
            ->get();

        return view('admin.dashboard', [
            'productsStats' => $productsStats,
            'storesStats' => $storesStats,
            'ordersStats' => $ordersStats,
            'stockStats' => $stockStats,
            'lowStockAlerts' => $lowStockAlerts,
            'recentOrders' => $recentOrders,
        ]);
    }
}
