<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\RedirectResponse;
use Illuminate\View\View;
use Illuminate\Support\Facades\Auth;

class AuthController extends Controller
{
    public function showLoginForm(): View
    {
        return view('admin.auth.login');
    }

    public function login(Request $request): RedirectResponse
    {
        $credentials = $request->validate([
            'email' => 'required|email',
            'password' => 'required',
        ]);

        if (Auth::attempt($credentials)) {
            $user = Auth::user();

            // Check if user is admin and active
            if ($user->role !== 'ADMIN') {
                Auth::logout();
                return redirect()->route('admin.login')
                    ->with('error', 'Accès refusé. Vous n\'êtes pas administrateur.');
            }

            if (!$user->is_active) {
                Auth::logout();
                return redirect()->route('admin.login')
                    ->with('error', 'Votre compte est désactivé. Contactez un administrateur.');
            }

            $request->session()->regenerate();

            return redirect()->intended(route('admin.dashboard'));
        }

        return redirect()->route('admin.login')
            ->with('error', 'Email ou mot de passe incorrect.');
    }

    public function logout(Request $request): RedirectResponse
    {
        Auth::logout();

        $request->session()->invalidate();
        $request->session()->regenerateToken();

        return redirect()->route('admin.login');
    }
}
